/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class Tags
implements Serializable {
    static final Function<com.google.api.services.compute.model.Tags, Tags> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.Tags, Tags>(){

        public Tags apply(com.google.api.services.compute.model.Tags pb) {
            return Tags.fromPb(pb);
        }
    };
    static final Function<Tags, com.google.api.services.compute.model.Tags> TO_PB_FUNCTION = new Function<Tags, com.google.api.services.compute.model.Tags>(){

        public com.google.api.services.compute.model.Tags apply(Tags tags) {
            return tags.toPb();
        }
    };
    private static final long serialVersionUID = 5627093820497225322L;
    private final List<String> values;
    private final String fingerprint;

    private Tags(Builder builder) {
        this.values = ImmutableList.copyOf((Collection)builder.values);
        this.fingerprint = builder.fingerprint;
    }

    @Deprecated
    public List<String> values() {
        return this.getValues();
    }

    public List<String> getValues() {
        return this.values;
    }

    @Deprecated
    public String fingerprint() {
        return this.getFingerprint();
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).add("fingerprint", (Object)this.fingerprint).toString();
    }

    public int hashCode() {
        return Objects.hash(this.values, this.fingerprint);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Tags && Objects.equals(this.toPb(), ((Tags)obj).toPb());
    }

    com.google.api.services.compute.model.Tags toPb() {
        com.google.api.services.compute.model.Tags tagsPb = new com.google.api.services.compute.model.Tags();
        tagsPb.setFingerprint(this.fingerprint);
        tagsPb.setItems(this.values);
        return tagsPb;
    }

    @Deprecated
    public static Builder builder(Iterable<String> values) {
        return Tags.newBuilder(values);
    }

    public static Builder newBuilder(Iterable<String> values) {
        return new Builder().setValues(values);
    }

    @Deprecated
    public static Builder builder(String ... values) {
        return Tags.newBuilder(values);
    }

    public static Builder newBuilder(String ... values) {
        return new Builder().setValues(values);
    }

    public static Tags of(Iterable<String> values) {
        return Tags.newBuilder(values).build();
    }

    public static Tags of(String ... values) {
        return Tags.newBuilder(values).build();
    }

    static Tags fromPb(com.google.api.services.compute.model.Tags tagsPb) {
        Builder builder = Tags.newBuilder(tagsPb.getItems() != null ? tagsPb.getItems() : ImmutableList.of());
        return builder.setFingerprint(tagsPb.getFingerprint()).build();
    }

    public static final class Builder {
        private List<String> values;
        private String fingerprint;

        private Builder() {
            this.values = Lists.newArrayList();
        }

        private Builder(Tags tags) {
            this.values = tags.values != null ? Lists.newArrayList((Iterable)tags.values) : Lists.newArrayList();
            this.fingerprint = tags.fingerprint;
        }

        @Deprecated
        public Builder values(Iterable<String> values) {
            return this.setValues(values);
        }

        public Builder setValues(Iterable<String> values) {
            this.values = Lists.newArrayList(values);
            return this;
        }

        @Deprecated
        public Builder values(String ... values) {
            return this.setValues(values);
        }

        public Builder setValues(String ... values) {
            this.values = Lists.newArrayList(Arrays.asList((Object[])Preconditions.checkNotNull((Object)values)));
            return this;
        }

        public Builder add(String tag) {
            this.values.add(tag);
            return this;
        }

        @Deprecated
        public Builder fingerprint(String fingerprint) {
            return this.setFingerprint(fingerprint);
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Tags build() {
            return new Tags(this);
        }
    }
}

