/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeFactory;
import com.google.cloud.compute.ComputeImpl;
import com.google.cloud.compute.spi.ComputeRpc;
import com.google.cloud.compute.spi.ComputeRpcFactory;
import com.google.cloud.compute.spi.DefaultComputeRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ComputeOptions
extends HttpServiceOptions<Compute, ComputeRpc, ComputeOptions> {
    private static final String COMPUTE_SCOPE = "https://www.googleapis.com/auth/compute";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/compute");
    private static final long serialVersionUID = 6983703596543425691L;

    private ComputeOptions(Builder builder) {
        super(ComputeFactory.class, ComputeRpcFactory.class, (HttpServiceOptions.Builder)builder);
    }

    protected ComputeFactory getDefaultServiceFactory() {
        return DefaultComputeFactory.INSTANCE;
    }

    protected ComputeRpcFactory getDefaultRpcFactory() {
        return DefaultComputeRpcFactory.INSTANCE;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeOptions)) {
            return false;
        }
        ComputeOptions other = (ComputeOptions)((Object)obj);
        return this.baseEquals(other);
    }

    @Deprecated
    public static ComputeOptions defaultInstance() {
        return ComputeOptions.getDefaultInstance();
    }

    public static ComputeOptions getDefaultInstance() {
        return ComputeOptions.newBuilder().build();
    }

    @Deprecated
    public static Builder builder() {
        return ComputeOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Compute, ComputeRpc, ComputeOptions, Builder> {
        private Builder() {
        }

        private Builder(ComputeOptions options) {
            super((HttpServiceOptions)options);
        }

        public ComputeOptions build() {
            return new ComputeOptions(this);
        }
    }

    public static class DefaultComputeRpcFactory
    implements ComputeRpcFactory {
        private static final ComputeRpcFactory INSTANCE = new DefaultComputeRpcFactory();

        public ComputeRpc create(ComputeOptions options) {
            return new DefaultComputeRpc(options);
        }
    }

    public static class DefaultComputeFactory
    implements ComputeFactory {
        private static final ComputeFactory INSTANCE = new DefaultComputeFactory();

        public Compute create(ComputeOptions options) {
            return new ComputeImpl(options);
        }
    }
}

