/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionBackendServiceName
implements ResourceName {
    private final String backendService;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/backendServices/{backendService}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionBackendServiceName(Builder builder) {
        this.backendService = (String)Preconditions.checkNotNull((Object)builder.getBackendService());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionBackendServiceName of(String backendService, String project, String region) {
        return ProjectRegionBackendServiceName.newBuilder().setBackendService(backendService).setProject(project).setRegion(region).build();
    }

    public static String format(String backendService, String project, String region) {
        return ProjectRegionBackendServiceName.of(backendService, project, region).toString();
    }

    public String getBackendService() {
        return this.backendService;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionBackendServiceName projectRegionBackendServiceName = this;
            synchronized (projectRegionBackendServiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"backendService", (Object)this.backendService);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionBackendServiceName> newFactory() {
        return new ResourceNameFactory<ProjectRegionBackendServiceName>(){

            public ProjectRegionBackendServiceName parse(String formattedString) {
                return ProjectRegionBackendServiceName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionBackendServiceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionBackendServiceName.parse: formattedString not in valid format");
        return ProjectRegionBackendServiceName.of((String)matchMap.get("backendService"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"backendService", this.backendService, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionBackendServiceName) {
            ProjectRegionBackendServiceName that = (ProjectRegionBackendServiceName)o;
            return Objects.equals(this.backendService, that.getBackendService()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendService, this.project, this.region);
    }

    public static class Builder {
        private String backendService;
        private String project;
        private String region;

        public String getBackendService() {
            return this.backendService;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setBackendService(String backendService) {
            this.backendService = backendService;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionBackendServiceName projectRegionBackendServiceName) {
            this.backendService = projectRegionBackendServiceName.backendService;
            this.project = projectRegionBackendServiceName.project;
            this.region = projectRegionBackendServiceName.region;
        }

        public ProjectRegionBackendServiceName build() {
            return new ProjectRegionBackendServiceName(this);
        }
    }
}

