/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneOperationName
implements ResourceName {
    private final String operation;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/operations/{operation}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneOperationName(Builder builder) {
        this.operation = (String)Preconditions.checkNotNull((Object)builder.getOperation());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneOperationName of(String operation, String project, String zone) {
        return ProjectZoneOperationName.newBuilder().setOperation(operation).setProject(project).setZone(zone).build();
    }

    public static String format(String operation, String project, String zone) {
        return ProjectZoneOperationName.of(operation, project, zone).toString();
    }

    public String getOperation() {
        return this.operation;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneOperationName projectZoneOperationName = this;
            synchronized (projectZoneOperationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"operation", (Object)this.operation);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneOperationName> newFactory() {
        return new ResourceNameFactory<ProjectZoneOperationName>(){

            public ProjectZoneOperationName parse(String formattedString) {
                return ProjectZoneOperationName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneOperationName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneOperationName.parse: formattedString not in valid format");
        return ProjectZoneOperationName.of((String)matchMap.get("operation"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"operation", this.operation, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneOperationName) {
            ProjectZoneOperationName that = (ProjectZoneOperationName)o;
            return Objects.equals(this.operation, that.getOperation()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.project, this.zone);
    }

    public static class Builder {
        private String operation;
        private String project;
        private String zone;

        public String getOperation() {
            return this.operation;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneOperationName projectZoneOperationName) {
            this.operation = projectZoneOperationName.operation;
            this.project = projectZoneOperationName.project;
            this.zone = projectZoneOperationName.zone;
        }

        public ProjectZoneOperationName build() {
            return new ProjectZoneOperationName(this);
        }
    }
}

