/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalHttpsHealthCheckName
implements ResourceName {
    private final String httpsHealthCheck;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/httpsHealthChecks/{httpsHealthCheck}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalHttpsHealthCheckName(Builder builder) {
        this.httpsHealthCheck = (String)Preconditions.checkNotNull((Object)builder.getHttpsHealthCheck());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalHttpsHealthCheckName of(String httpsHealthCheck, String project) {
        return ProjectGlobalHttpsHealthCheckName.newBuilder().setHttpsHealthCheck(httpsHealthCheck).setProject(project).build();
    }

    public static String format(String httpsHealthCheck, String project) {
        return ProjectGlobalHttpsHealthCheckName.of(httpsHealthCheck, project).toString();
    }

    public String getHttpsHealthCheck() {
        return this.httpsHealthCheck;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalHttpsHealthCheckName projectGlobalHttpsHealthCheckName = this;
            synchronized (projectGlobalHttpsHealthCheckName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"httpsHealthCheck", (Object)this.httpsHealthCheck);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalHttpsHealthCheckName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalHttpsHealthCheckName>(){

            public ProjectGlobalHttpsHealthCheckName parse(String formattedString) {
                return ProjectGlobalHttpsHealthCheckName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalHttpsHealthCheckName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalHttpsHealthCheckName.parse: formattedString not in valid format");
        return ProjectGlobalHttpsHealthCheckName.of((String)matchMap.get("httpsHealthCheck"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"httpsHealthCheck", this.httpsHealthCheck, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalHttpsHealthCheckName) {
            ProjectGlobalHttpsHealthCheckName that = (ProjectGlobalHttpsHealthCheckName)o;
            return Objects.equals(this.httpsHealthCheck, that.getHttpsHealthCheck()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.httpsHealthCheck, this.project);
    }

    public static class Builder {
        private String httpsHealthCheck;
        private String project;

        public String getHttpsHealthCheck() {
            return this.httpsHealthCheck;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setHttpsHealthCheck(String httpsHealthCheck) {
            this.httpsHealthCheck = httpsHealthCheck;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalHttpsHealthCheckName projectGlobalHttpsHealthCheckName) {
            this.httpsHealthCheck = projectGlobalHttpsHealthCheckName.httpsHealthCheck;
            this.project = projectGlobalHttpsHealthCheckName.project;
        }

        public ProjectGlobalHttpsHealthCheckName build() {
            return new ProjectGlobalHttpsHealthCheckName(this);
        }
    }
}

