/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GetInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplateList;
import com.google.cloud.compute.v1.InstanceTemplateSettings;
import com.google.cloud.compute.v1.ListInstanceTemplatesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalInstanceTemplateName;
import com.google.cloud.compute.v1.ProjectGlobalInstanceTemplateResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicyInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceTemplateHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.InstanceTemplateStub;
import com.google.cloud.compute.v1.stub.InstanceTemplateStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstanceTemplateClient
implements BackgroundResource {
    private final InstanceTemplateSettings settings;
    private final InstanceTemplateStub stub;

    public static final InstanceTemplateClient create() throws IOException {
        return InstanceTemplateClient.create(InstanceTemplateSettings.newBuilder().build());
    }

    public static final InstanceTemplateClient create(InstanceTemplateSettings settings) throws IOException {
        return new InstanceTemplateClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceTemplateClient create(InstanceTemplateStub stub) {
        return new InstanceTemplateClient(stub);
    }

    protected InstanceTemplateClient(InstanceTemplateSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceTemplateStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceTemplateClient(InstanceTemplateStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceTemplateSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceTemplateStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteInstanceTemplate(ProjectGlobalInstanceTemplateName instanceTemplate) {
        DeleteInstanceTemplateHttpRequest request = DeleteInstanceTemplateHttpRequest.newBuilder().setInstanceTemplate(instanceTemplate == null ? null : instanceTemplate.toString()).build();
        return this.deleteInstanceTemplate(request);
    }

    @BetaApi
    public final Operation deleteInstanceTemplate(String instanceTemplate) {
        DeleteInstanceTemplateHttpRequest request = DeleteInstanceTemplateHttpRequest.newBuilder().setInstanceTemplate(instanceTemplate).build();
        return this.deleteInstanceTemplate(request);
    }

    @BetaApi
    public final Operation deleteInstanceTemplate(DeleteInstanceTemplateHttpRequest request) {
        return (Operation)this.deleteInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteInstanceTemplateHttpRequest, Operation> deleteInstanceTemplateCallable() {
        return this.stub.deleteInstanceTemplateCallable();
    }

    @BetaApi
    public final InstanceTemplate getInstanceTemplate(ProjectGlobalInstanceTemplateName instanceTemplate) {
        GetInstanceTemplateHttpRequest request = GetInstanceTemplateHttpRequest.newBuilder().setInstanceTemplate(instanceTemplate == null ? null : instanceTemplate.toString()).build();
        return this.getInstanceTemplate(request);
    }

    @BetaApi
    public final InstanceTemplate getInstanceTemplate(String instanceTemplate) {
        GetInstanceTemplateHttpRequest request = GetInstanceTemplateHttpRequest.newBuilder().setInstanceTemplate(instanceTemplate).build();
        return this.getInstanceTemplate(request);
    }

    @BetaApi
    public final InstanceTemplate getInstanceTemplate(GetInstanceTemplateHttpRequest request) {
        return (InstanceTemplate)this.getInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetInstanceTemplateHttpRequest, InstanceTemplate> getInstanceTemplateCallable() {
        return this.stub.getInstanceTemplateCallable();
    }

    @BetaApi
    public final Policy getIamPolicyInstanceTemplate(ProjectGlobalInstanceTemplateResourceName resource) {
        GetIamPolicyInstanceTemplateHttpRequest request = GetIamPolicyInstanceTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyInstanceTemplate(request);
    }

    @BetaApi
    public final Policy getIamPolicyInstanceTemplate(String resource) {
        GetIamPolicyInstanceTemplateHttpRequest request = GetIamPolicyInstanceTemplateHttpRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyInstanceTemplate(request);
    }

    @BetaApi
    public final Policy getIamPolicyInstanceTemplate(GetIamPolicyInstanceTemplateHttpRequest request) {
        return (Policy)this.getIamPolicyInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyInstanceTemplateHttpRequest, Policy> getIamPolicyInstanceTemplateCallable() {
        return this.stub.getIamPolicyInstanceTemplateCallable();
    }

    @BetaApi
    public final Operation insertInstanceTemplate(ProjectName project, InstanceTemplate instanceTemplateResource) {
        InsertInstanceTemplateHttpRequest request = InsertInstanceTemplateHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setInstanceTemplateResource(instanceTemplateResource).build();
        return this.insertInstanceTemplate(request);
    }

    @BetaApi
    public final Operation insertInstanceTemplate(String project, InstanceTemplate instanceTemplateResource) {
        InsertInstanceTemplateHttpRequest request = InsertInstanceTemplateHttpRequest.newBuilder().setProject(project).setInstanceTemplateResource(instanceTemplateResource).build();
        return this.insertInstanceTemplate(request);
    }

    @BetaApi
    public final Operation insertInstanceTemplate(InsertInstanceTemplateHttpRequest request) {
        return (Operation)this.insertInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertInstanceTemplateHttpRequest, Operation> insertInstanceTemplateCallable() {
        return this.stub.insertInstanceTemplateCallable();
    }

    @BetaApi
    public final ListInstanceTemplatesPagedResponse listInstanceTemplates(ProjectName project) {
        ListInstanceTemplatesHttpRequest request = ListInstanceTemplatesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listInstanceTemplates(request);
    }

    @BetaApi
    public final ListInstanceTemplatesPagedResponse listInstanceTemplates(String project) {
        ListInstanceTemplatesHttpRequest request = ListInstanceTemplatesHttpRequest.newBuilder().setProject(project).build();
        return this.listInstanceTemplates(request);
    }

    @BetaApi
    public final ListInstanceTemplatesPagedResponse listInstanceTemplates(ListInstanceTemplatesHttpRequest request) {
        return (ListInstanceTemplatesPagedResponse)((Object)this.listInstanceTemplatesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListInstanceTemplatesHttpRequest, ListInstanceTemplatesPagedResponse> listInstanceTemplatesPagedCallable() {
        return this.stub.listInstanceTemplatesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListInstanceTemplatesHttpRequest, InstanceTemplateList> listInstanceTemplatesCallable() {
        return this.stub.listInstanceTemplatesCallable();
    }

    @BetaApi
    public final Policy setIamPolicyInstanceTemplate(ProjectGlobalInstanceTemplateResourceName resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyInstanceTemplateHttpRequest request = SetIamPolicyInstanceTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicyInstanceTemplate(request);
    }

    @BetaApi
    public final Policy setIamPolicyInstanceTemplate(String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyInstanceTemplateHttpRequest request = SetIamPolicyInstanceTemplateHttpRequest.newBuilder().setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicyInstanceTemplate(request);
    }

    @BetaApi
    public final Policy setIamPolicyInstanceTemplate(SetIamPolicyInstanceTemplateHttpRequest request) {
        return (Policy)this.setIamPolicyInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyInstanceTemplateHttpRequest, Policy> setIamPolicyInstanceTemplateCallable() {
        return this.stub.setIamPolicyInstanceTemplateCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsInstanceTemplate(ProjectGlobalInstanceTemplateResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInstanceTemplateHttpRequest request = TestIamPermissionsInstanceTemplateHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsInstanceTemplate(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsInstanceTemplate(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInstanceTemplateHttpRequest request = TestIamPermissionsInstanceTemplateHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsInstanceTemplate(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsInstanceTemplate(TestIamPermissionsInstanceTemplateHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsInstanceTemplateCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsInstanceTemplateHttpRequest, TestPermissionsResponse> testIamPermissionsInstanceTemplateCallable() {
        return this.stub.testIamPermissionsInstanceTemplateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstanceTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate, ListInstanceTemplatesPage, ListInstanceTemplatesFixedSizeCollection> {
        private ListInstanceTemplatesFixedSizeCollection(List<ListInstanceTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListInstanceTemplatesFixedSizeCollection(null, 0);
        }

        protected ListInstanceTemplatesFixedSizeCollection createCollection(List<ListInstanceTemplatesPage> pages, int collectionSize) {
            return new ListInstanceTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceTemplatesPage
    extends AbstractPage<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate, ListInstanceTemplatesPage> {
        private ListInstanceTemplatesPage(PageContext<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            super(context, (Object)response);
        }

        private static ListInstanceTemplatesPage createEmptyPage() {
            return new ListInstanceTemplatesPage(null, null);
        }

        protected ListInstanceTemplatesPage createPage(PageContext<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            return new ListInstanceTemplatesPage(context, response);
        }

        public ApiFuture<ListInstanceTemplatesPage> createPageAsync(PageContext<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceTemplatesPagedResponse
    extends AbstractPagedListResponse<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate, ListInstanceTemplatesPage, ListInstanceTemplatesFixedSizeCollection> {
        public static ApiFuture<ListInstanceTemplatesPagedResponse> createAsync(PageContext<ListInstanceTemplatesHttpRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            ApiFuture<ListInstanceTemplatesPage> futurePage = ListInstanceTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstanceTemplatesPage, ListInstanceTemplatesPagedResponse>(){

                public ListInstanceTemplatesPagedResponse apply(ListInstanceTemplatesPage input) {
                    return new ListInstanceTemplatesPagedResponse(input);
                }
            });
        }

        private ListInstanceTemplatesPagedResponse(ListInstanceTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

