/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetSslProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetSslProxyHttpRequest;
import com.google.cloud.compute.v1.TargetSslProxy;
import com.google.cloud.compute.v1.TargetSslProxyClient;
import com.google.cloud.compute.v1.TargetSslProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetSslProxyStub;
import com.google.cloud.compute.v1.stub.TargetSslProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetSslProxyStubSettings
extends StubSettings<TargetSslProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteTargetSslProxyHttpRequest, Operation> deleteTargetSslProxySettings;
    private final UnaryCallSettings<GetTargetSslProxyHttpRequest, TargetSslProxy> getTargetSslProxySettings;
    private final UnaryCallSettings<InsertTargetSslProxyHttpRequest, Operation> insertTargetSslProxySettings;
    private final PagedCallSettings<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse> listTargetSslProxiesSettings;
    private final UnaryCallSettings<SetBackendServiceTargetSslProxyHttpRequest, Operation> setBackendServiceTargetSslProxySettings;
    private final UnaryCallSettings<SetProxyHeaderTargetSslProxyHttpRequest, Operation> setProxyHeaderTargetSslProxySettings;
    private final UnaryCallSettings<SetSslCertificatesTargetSslProxyHttpRequest, Operation> setSslCertificatesTargetSslProxySettings;
    private final UnaryCallSettings<SetSslPolicyTargetSslProxyHttpRequest, Operation> setSslPolicyTargetSslProxySettings;
    private static final PagedListDescriptor<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy> LIST_TARGET_SSL_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetSslProxiesHttpRequest injectToken(ListTargetSslProxiesHttpRequest payload, String token) {
            return ListTargetSslProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetSslProxiesHttpRequest injectPageSize(ListTargetSslProxiesHttpRequest payload, int pageSize) {
            return ListTargetSslProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetSslProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetSslProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetSslProxy> extractResources(TargetSslProxyList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse> LIST_TARGET_SSL_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse>(){

        public ApiFuture<TargetSslProxyClient.ListTargetSslProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetSslProxiesHttpRequest, TargetSslProxyList> callable, ListTargetSslProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetSslProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_SSL_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetSslProxyClient.ListTargetSslProxiesPagedResponse.createAsync((PageContext<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetSslProxyHttpRequest, Operation> deleteTargetSslProxySettings() {
        return this.deleteTargetSslProxySettings;
    }

    public UnaryCallSettings<GetTargetSslProxyHttpRequest, TargetSslProxy> getTargetSslProxySettings() {
        return this.getTargetSslProxySettings;
    }

    public UnaryCallSettings<InsertTargetSslProxyHttpRequest, Operation> insertTargetSslProxySettings() {
        return this.insertTargetSslProxySettings;
    }

    public PagedCallSettings<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse> listTargetSslProxiesSettings() {
        return this.listTargetSslProxiesSettings;
    }

    public UnaryCallSettings<SetBackendServiceTargetSslProxyHttpRequest, Operation> setBackendServiceTargetSslProxySettings() {
        return this.setBackendServiceTargetSslProxySettings;
    }

    public UnaryCallSettings<SetProxyHeaderTargetSslProxyHttpRequest, Operation> setProxyHeaderTargetSslProxySettings() {
        return this.setProxyHeaderTargetSslProxySettings;
    }

    public UnaryCallSettings<SetSslCertificatesTargetSslProxyHttpRequest, Operation> setSslCertificatesTargetSslProxySettings() {
        return this.setSslCertificatesTargetSslProxySettings;
    }

    public UnaryCallSettings<SetSslPolicyTargetSslProxyHttpRequest, Operation> setSslPolicyTargetSslProxySettings() {
        return this.setSslPolicyTargetSslProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetSslProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetSslProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetSslProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetSslProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetSslProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteTargetSslProxySettings = settingsBuilder.deleteTargetSslProxySettings().build();
        this.getTargetSslProxySettings = settingsBuilder.getTargetSslProxySettings().build();
        this.insertTargetSslProxySettings = settingsBuilder.insertTargetSslProxySettings().build();
        this.listTargetSslProxiesSettings = settingsBuilder.listTargetSslProxiesSettings().build();
        this.setBackendServiceTargetSslProxySettings = settingsBuilder.setBackendServiceTargetSslProxySettings().build();
        this.setProxyHeaderTargetSslProxySettings = settingsBuilder.setProxyHeaderTargetSslProxySettings().build();
        this.setSslCertificatesTargetSslProxySettings = settingsBuilder.setSslCertificatesTargetSslProxySettings().build();
        this.setSslPolicyTargetSslProxySettings = settingsBuilder.setSslPolicyTargetSslProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetSslProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetSslProxyHttpRequest, Operation> deleteTargetSslProxySettings;
        private final UnaryCallSettings.Builder<GetTargetSslProxyHttpRequest, TargetSslProxy> getTargetSslProxySettings;
        private final UnaryCallSettings.Builder<InsertTargetSslProxyHttpRequest, Operation> insertTargetSslProxySettings;
        private final PagedCallSettings.Builder<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse> listTargetSslProxiesSettings;
        private final UnaryCallSettings.Builder<SetBackendServiceTargetSslProxyHttpRequest, Operation> setBackendServiceTargetSslProxySettings;
        private final UnaryCallSettings.Builder<SetProxyHeaderTargetSslProxyHttpRequest, Operation> setProxyHeaderTargetSslProxySettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesTargetSslProxyHttpRequest, Operation> setSslCertificatesTargetSslProxySettings;
        private final UnaryCallSettings.Builder<SetSslPolicyTargetSslProxyHttpRequest, Operation> setSslPolicyTargetSslProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetSslProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_SSL_PROXIES_PAGE_STR_FACT);
            this.setBackendServiceTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setProxyHeaderTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslCertificatesTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslPolicyTargetSslProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetSslProxySettings, this.getTargetSslProxySettings, this.insertTargetSslProxySettings, this.listTargetSslProxiesSettings, this.setBackendServiceTargetSslProxySettings, this.setProxyHeaderTargetSslProxySettings, this.setSslCertificatesTargetSslProxySettings, this.setSslPolicyTargetSslProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetSslProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetSslProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetSslProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetSslProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetSslProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setBackendServiceTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setProxyHeaderTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSslCertificatesTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSslPolicyTargetSslProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetSslProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteTargetSslProxySettings = settings.deleteTargetSslProxySettings.toBuilder();
            this.getTargetSslProxySettings = settings.getTargetSslProxySettings.toBuilder();
            this.insertTargetSslProxySettings = settings.insertTargetSslProxySettings.toBuilder();
            this.listTargetSslProxiesSettings = settings.listTargetSslProxiesSettings.toBuilder();
            this.setBackendServiceTargetSslProxySettings = settings.setBackendServiceTargetSslProxySettings.toBuilder();
            this.setProxyHeaderTargetSslProxySettings = settings.setProxyHeaderTargetSslProxySettings.toBuilder();
            this.setSslCertificatesTargetSslProxySettings = settings.setSslCertificatesTargetSslProxySettings.toBuilder();
            this.setSslPolicyTargetSslProxySettings = settings.setSslPolicyTargetSslProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetSslProxySettings, this.getTargetSslProxySettings, this.insertTargetSslProxySettings, this.listTargetSslProxiesSettings, this.setBackendServiceTargetSslProxySettings, this.setProxyHeaderTargetSslProxySettings, this.setSslCertificatesTargetSslProxySettings, this.setSslPolicyTargetSslProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetSslProxyHttpRequest, Operation> deleteTargetSslProxySettings() {
            return this.deleteTargetSslProxySettings;
        }

        public UnaryCallSettings.Builder<GetTargetSslProxyHttpRequest, TargetSslProxy> getTargetSslProxySettings() {
            return this.getTargetSslProxySettings;
        }

        public UnaryCallSettings.Builder<InsertTargetSslProxyHttpRequest, Operation> insertTargetSslProxySettings() {
            return this.insertTargetSslProxySettings;
        }

        public PagedCallSettings.Builder<ListTargetSslProxiesHttpRequest, TargetSslProxyList, TargetSslProxyClient.ListTargetSslProxiesPagedResponse> listTargetSslProxiesSettings() {
            return this.listTargetSslProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetBackendServiceTargetSslProxyHttpRequest, Operation> setBackendServiceTargetSslProxySettings() {
            return this.setBackendServiceTargetSslProxySettings;
        }

        public UnaryCallSettings.Builder<SetProxyHeaderTargetSslProxyHttpRequest, Operation> setProxyHeaderTargetSslProxySettings() {
            return this.setProxyHeaderTargetSslProxySettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesTargetSslProxyHttpRequest, Operation> setSslCertificatesTargetSslProxySettings() {
            return this.setSslCertificatesTargetSslProxySettings;
        }

        public UnaryCallSettings.Builder<SetSslPolicyTargetSslProxyHttpRequest, Operation> setSslPolicyTargetSslProxySettings() {
            return this.setSslPolicyTargetSslProxySettings;
        }

        public TargetSslProxyStubSettings build() throws IOException {
            return new TargetSslProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

