/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteImageHttpRequest;
import com.google.cloud.compute.v1.DeprecateImageHttpRequest;
import com.google.cloud.compute.v1.GetFromFamilyImageHttpRequest;
import com.google.cloud.compute.v1.GetImageHttpRequest;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.ImageClient;
import com.google.cloud.compute.v1.ImageList;
import com.google.cloud.compute.v1.InsertImageHttpRequest;
import com.google.cloud.compute.v1.ListImagesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetLabelsImageHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonImageStub;
import com.google.cloud.compute.v1.stub.ImageStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ImageStubSettings
extends StubSettings<ImageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteImageHttpRequest, Operation> deleteImageSettings;
    private final UnaryCallSettings<DeprecateImageHttpRequest, Operation> deprecateImageSettings;
    private final UnaryCallSettings<GetImageHttpRequest, Image> getImageSettings;
    private final UnaryCallSettings<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageSettings;
    private final UnaryCallSettings<InsertImageHttpRequest, Operation> insertImageSettings;
    private final PagedCallSettings<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse> listImagesSettings;
    private final UnaryCallSettings<SetLabelsImageHttpRequest, Operation> setLabelsImageSettings;
    private static final PagedListDescriptor<ListImagesHttpRequest, ImageList, Image> LIST_IMAGES_PAGE_STR_DESC = new PagedListDescriptor<ListImagesHttpRequest, ImageList, Image>(){

        public String emptyToken() {
            return "";
        }

        public ListImagesHttpRequest injectToken(ListImagesHttpRequest payload, String token) {
            return ListImagesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListImagesHttpRequest injectPageSize(ListImagesHttpRequest payload, int pageSize) {
            return ListImagesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListImagesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ImageList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Image> extractResources(ImageList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse> LIST_IMAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse>(){

        public ApiFuture<ImageClient.ListImagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListImagesHttpRequest, ImageList> callable, ListImagesHttpRequest request, ApiCallContext context, ApiFuture<ImageList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IMAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ImageClient.ListImagesPagedResponse.createAsync((PageContext<ListImagesHttpRequest, ImageList, Image>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteImageHttpRequest, Operation> deleteImageSettings() {
        return this.deleteImageSettings;
    }

    public UnaryCallSettings<DeprecateImageHttpRequest, Operation> deprecateImageSettings() {
        return this.deprecateImageSettings;
    }

    public UnaryCallSettings<GetImageHttpRequest, Image> getImageSettings() {
        return this.getImageSettings;
    }

    public UnaryCallSettings<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageSettings() {
        return this.getFromFamilyImageSettings;
    }

    public UnaryCallSettings<InsertImageHttpRequest, Operation> insertImageSettings() {
        return this.insertImageSettings;
    }

    public PagedCallSettings<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse> listImagesSettings() {
        return this.listImagesSettings;
    }

    public UnaryCallSettings<SetLabelsImageHttpRequest, Operation> setLabelsImageSettings() {
        return this.setLabelsImageSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ImageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonImageStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ImageStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImageStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ImageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteImageSettings = settingsBuilder.deleteImageSettings().build();
        this.deprecateImageSettings = settingsBuilder.deprecateImageSettings().build();
        this.getImageSettings = settingsBuilder.getImageSettings().build();
        this.getFromFamilyImageSettings = settingsBuilder.getFromFamilyImageSettings().build();
        this.insertImageSettings = settingsBuilder.insertImageSettings().build();
        this.listImagesSettings = settingsBuilder.listImagesSettings().build();
        this.setLabelsImageSettings = settingsBuilder.setLabelsImageSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ImageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteImageHttpRequest, Operation> deleteImageSettings;
        private final UnaryCallSettings.Builder<DeprecateImageHttpRequest, Operation> deprecateImageSettings;
        private final UnaryCallSettings.Builder<GetImageHttpRequest, Image> getImageSettings;
        private final UnaryCallSettings.Builder<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageSettings;
        private final UnaryCallSettings.Builder<InsertImageHttpRequest, Operation> insertImageSettings;
        private final PagedCallSettings.Builder<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse> listImagesSettings;
        private final UnaryCallSettings.Builder<SetLabelsImageHttpRequest, Operation> setLabelsImageSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deprecateImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFromFamilyImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listImagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IMAGES_PAGE_STR_FACT);
            this.setLabelsImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteImageSettings, this.deprecateImageSettings, this.getImageSettings, this.getFromFamilyImageSettings, this.insertImageSettings, this.listImagesSettings, this.setLabelsImageSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ImageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ImageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ImageStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deprecateImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getFromFamilyImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listImagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ImageStubSettings settings) {
            super((StubSettings)settings);
            this.deleteImageSettings = settings.deleteImageSettings.toBuilder();
            this.deprecateImageSettings = settings.deprecateImageSettings.toBuilder();
            this.getImageSettings = settings.getImageSettings.toBuilder();
            this.getFromFamilyImageSettings = settings.getFromFamilyImageSettings.toBuilder();
            this.insertImageSettings = settings.insertImageSettings.toBuilder();
            this.listImagesSettings = settings.listImagesSettings.toBuilder();
            this.setLabelsImageSettings = settings.setLabelsImageSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteImageSettings, this.deprecateImageSettings, this.getImageSettings, this.getFromFamilyImageSettings, this.insertImageSettings, this.listImagesSettings, this.setLabelsImageSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteImageHttpRequest, Operation> deleteImageSettings() {
            return this.deleteImageSettings;
        }

        public UnaryCallSettings.Builder<DeprecateImageHttpRequest, Operation> deprecateImageSettings() {
            return this.deprecateImageSettings;
        }

        public UnaryCallSettings.Builder<GetImageHttpRequest, Image> getImageSettings() {
            return this.getImageSettings;
        }

        public UnaryCallSettings.Builder<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageSettings() {
            return this.getFromFamilyImageSettings;
        }

        public UnaryCallSettings.Builder<InsertImageHttpRequest, Operation> insertImageSettings() {
            return this.insertImageSettings;
        }

        public PagedCallSettings.Builder<ListImagesHttpRequest, ImageList, ImageClient.ListImagesPagedResponse> listImagesSettings() {
            return this.listImagesSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsImageHttpRequest, Operation> setLabelsImageSettings() {
            return this.setLabelsImageSettings;
        }

        public ImageStubSettings build() throws IOException {
            return new ImageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

