/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.DeleteGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GetGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GlobalAddressClient;
import com.google.cloud.compute.v1.InsertGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.ListGlobalAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.GlobalAddressStub;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalAddressStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GlobalAddressStubSettings
extends StubSettings<GlobalAddressStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressSettings;
    private final UnaryCallSettings<GetGlobalAddressHttpRequest, Address> getGlobalAddressSettings;
    private final UnaryCallSettings<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressSettings;
    private final PagedCallSettings<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesSettings;
    private static final PagedListDescriptor<ListGlobalAddressesHttpRequest, AddressList, Address> LIST_GLOBAL_ADDRESSES_PAGE_STR_DESC = new PagedListDescriptor<ListGlobalAddressesHttpRequest, AddressList, Address>(){

        public String emptyToken() {
            return "";
        }

        public ListGlobalAddressesHttpRequest injectToken(ListGlobalAddressesHttpRequest payload, String token) {
            return ListGlobalAddressesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListGlobalAddressesHttpRequest injectPageSize(ListGlobalAddressesHttpRequest payload, int pageSize) {
            return ListGlobalAddressesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListGlobalAddressesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AddressList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Address> extractResources(AddressList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse> LIST_GLOBAL_ADDRESSES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse>(){

        public ApiFuture<GlobalAddressClient.ListGlobalAddressesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlobalAddressesHttpRequest, AddressList> callable, ListGlobalAddressesHttpRequest request, ApiCallContext context, ApiFuture<AddressList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOBAL_ADDRESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalAddressClient.ListGlobalAddressesPagedResponse.createAsync((PageContext<ListGlobalAddressesHttpRequest, AddressList, Address>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressSettings() {
        return this.deleteGlobalAddressSettings;
    }

    public UnaryCallSettings<GetGlobalAddressHttpRequest, Address> getGlobalAddressSettings() {
        return this.getGlobalAddressSettings;
    }

    public UnaryCallSettings<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressSettings() {
        return this.insertGlobalAddressSettings;
    }

    public PagedCallSettings<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesSettings() {
        return this.listGlobalAddressesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalAddressStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGlobalAddressStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GlobalAddressStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GlobalAddressStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GlobalAddressStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteGlobalAddressSettings = settingsBuilder.deleteGlobalAddressSettings().build();
        this.getGlobalAddressSettings = settingsBuilder.getGlobalAddressSettings().build();
        this.insertGlobalAddressSettings = settingsBuilder.insertGlobalAddressSettings().build();
        this.listGlobalAddressesSettings = settingsBuilder.listGlobalAddressesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GlobalAddressStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressSettings;
        private final UnaryCallSettings.Builder<GetGlobalAddressHttpRequest, Address> getGlobalAddressSettings;
        private final UnaryCallSettings.Builder<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressSettings;
        private final PagedCallSettings.Builder<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteGlobalAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlobalAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertGlobalAddressSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlobalAddressesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOBAL_ADDRESSES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteGlobalAddressSettings, this.getGlobalAddressSettings, this.insertGlobalAddressSettings, this.listGlobalAddressesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GlobalAddressStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GlobalAddressStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GlobalAddressStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GlobalAddressStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteGlobalAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGlobalAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertGlobalAddressSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGlobalAddressesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(GlobalAddressStubSettings settings) {
            super((StubSettings)settings);
            this.deleteGlobalAddressSettings = settings.deleteGlobalAddressSettings.toBuilder();
            this.getGlobalAddressSettings = settings.getGlobalAddressSettings.toBuilder();
            this.insertGlobalAddressSettings = settings.insertGlobalAddressSettings.toBuilder();
            this.listGlobalAddressesSettings = settings.listGlobalAddressesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteGlobalAddressSettings, this.getGlobalAddressSettings, this.insertGlobalAddressSettings, this.listGlobalAddressesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressSettings() {
            return this.deleteGlobalAddressSettings;
        }

        public UnaryCallSettings.Builder<GetGlobalAddressHttpRequest, Address> getGlobalAddressSettings() {
            return this.getGlobalAddressSettings;
        }

        public UnaryCallSettings.Builder<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressSettings() {
            return this.insertGlobalAddressSettings;
        }

        public PagedCallSettings.Builder<ListGlobalAddressesHttpRequest, AddressList, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesSettings() {
            return this.listGlobalAddressesSettings;
        }

        public GlobalAddressStubSettings build() throws IOException {
            return new GlobalAddressStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

