/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionTargetPoolName
implements ResourceName {
    private final String project;
    private final String region;
    private final String targetPool;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/targetPools/{targetPool}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionTargetPoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.targetPool = (String)Preconditions.checkNotNull((Object)builder.getTargetPool());
    }

    public static ProjectRegionTargetPoolName of(String project, String region, String targetPool) {
        return ProjectRegionTargetPoolName.newBuilder().setProject(project).setRegion(region).setTargetPool(targetPool).build();
    }

    public static String format(String project, String region, String targetPool) {
        return ProjectRegionTargetPoolName.of(project, region, targetPool).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTargetPool() {
        return this.targetPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionTargetPoolName projectRegionTargetPoolName = this;
            synchronized (projectRegionTargetPoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"targetPool", (Object)this.targetPool);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionTargetPoolName> newFactory() {
        return new ResourceNameFactory<ProjectRegionTargetPoolName>(){

            public ProjectRegionTargetPoolName parse(String formattedString) {
                return ProjectRegionTargetPoolName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionTargetPoolName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionTargetPoolName.parse: formattedString not in valid format");
        return ProjectRegionTargetPoolName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("targetPool"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "targetPool", this.targetPool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionTargetPoolName) {
            ProjectRegionTargetPoolName that = (ProjectRegionTargetPoolName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.targetPool, that.getTargetPool());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.targetPool);
    }

    public static class Builder {
        private String project;
        private String region;
        private String targetPool;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getTargetPool() {
            return this.targetPool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setTargetPool(String targetPool) {
            this.targetPool = targetPool;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionTargetPoolName projectRegionTargetPoolName) {
            this.project = projectRegionTargetPoolName.project;
            this.region = projectRegionTargetPoolName.region;
            this.targetPool = projectRegionTargetPoolName.targetPool;
        }

        public ProjectRegionTargetPoolName build() {
            return new ProjectRegionTargetPoolName(this);
        }
    }
}

