/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionRouterName
implements ResourceName {
    private final String project;
    private final String region;
    private final String router;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/routers/{router}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionRouterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.router = (String)Preconditions.checkNotNull((Object)builder.getRouter());
    }

    public static ProjectRegionRouterName of(String project, String region, String router) {
        return ProjectRegionRouterName.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
    }

    public static String format(String project, String region, String router) {
        return ProjectRegionRouterName.of(project, region, router).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRouter() {
        return this.router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionRouterName projectRegionRouterName = this;
            synchronized (projectRegionRouterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"router", (Object)this.router);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionRouterName> newFactory() {
        return new ResourceNameFactory<ProjectRegionRouterName>(){

            public ProjectRegionRouterName parse(String formattedString) {
                return ProjectRegionRouterName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionRouterName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionRouterName.parse: formattedString not in valid format");
        return ProjectRegionRouterName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("router"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "router", this.router});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionRouterName) {
            ProjectRegionRouterName that = (ProjectRegionRouterName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.router, that.getRouter());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.router);
    }

    public static class Builder {
        private String project;
        private String region;
        private String router;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getRouter() {
            return this.router;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setRouter(String router) {
            this.router = router;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionRouterName projectRegionRouterName) {
            this.project = projectRegionRouterName.project;
            this.region = projectRegionRouterName.region;
            this.router = projectRegionRouterName.router;
        }

        public ProjectRegionRouterName build() {
            return new ProjectRegionRouterName(this);
        }
    }
}

