/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalTargetSslProxyName
implements ResourceName {
    private final String project;
    private final String targetSslProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/global/targetSslProxies/{targetSslProxy}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalTargetSslProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.targetSslProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetSslProxy());
    }

    public static ProjectGlobalTargetSslProxyName of(String project, String targetSslProxy) {
        return ProjectGlobalTargetSslProxyName.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).build();
    }

    public static String format(String project, String targetSslProxy) {
        return ProjectGlobalTargetSslProxyName.of(project, targetSslProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getTargetSslProxy() {
        return this.targetSslProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalTargetSslProxyName projectGlobalTargetSslProxyName = this;
            synchronized (projectGlobalTargetSslProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"targetSslProxy", (Object)this.targetSslProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalTargetSslProxyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalTargetSslProxyName>(){

            public ProjectGlobalTargetSslProxyName parse(String formattedString) {
                return ProjectGlobalTargetSslProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalTargetSslProxyName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectGlobalTargetSslProxyName.parse: formattedString not in valid format");
        return ProjectGlobalTargetSslProxyName.of((String)matchMap.get("project"), (String)matchMap.get("targetSslProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "targetSslProxy", this.targetSslProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalTargetSslProxyName) {
            ProjectGlobalTargetSslProxyName that = (ProjectGlobalTargetSslProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.targetSslProxy, that.getTargetSslProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.targetSslProxy);
    }

    public static class Builder {
        private String project;
        private String targetSslProxy;

        public String getProject() {
            return this.project;
        }

        public String getTargetSslProxy() {
            return this.targetSslProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTargetSslProxy(String targetSslProxy) {
            this.targetSslProxy = targetSslProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalTargetSslProxyName projectGlobalTargetSslProxyName) {
            this.project = projectGlobalTargetSslProxyName.project;
            this.targetSslProxy = projectGlobalTargetSslProxyName.targetSslProxy;
        }

        public ProjectGlobalTargetSslProxyName build() {
            return new ProjectGlobalTargetSslProxyName(this);
        }
    }
}

