/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NamedPort
implements ApiMessage {
    private final String name;
    private final Integer port;
    private static final NamedPort DEFAULT_INSTANCE = new NamedPort();

    private NamedPort() {
        this.name = null;
        this.port = null;
    }

    private NamedPort(String name, Integer port) {
        this.name = name;
        this.port = port;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("port")) {
            return this.port;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPort() {
        return this.port;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NamedPort prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NamedPort getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NamedPort{name=" + this.name + ", port=" + this.port + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NamedPort) {
            NamedPort that = (NamedPort)o;
            return Objects.equals(this.name, that.getName()) && Objects.equals(this.port, that.getPort());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.port);
    }

    public static class Builder {
        private String name;
        private Integer port;

        Builder() {
        }

        public Builder mergeFrom(NamedPort other) {
            if (other == NamedPort.getDefaultInstance()) {
                return this;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            return this;
        }

        Builder(NamedPort source) {
            this.name = source.name;
            this.port = source.port;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public NamedPort build() {
            return new NamedPort(this.name, this.port);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setName(this.name);
            newBuilder.setPort(this.port);
            return newBuilder;
        }
    }
}

