/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AcceleratorConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstancesSetMachineResourcesRequest
implements ApiMessage {
    private final List<AcceleratorConfig> guestAccelerators;
    private static final InstancesSetMachineResourcesRequest DEFAULT_INSTANCE = new InstancesSetMachineResourcesRequest();

    private InstancesSetMachineResourcesRequest() {
        this.guestAccelerators = null;
    }

    private InstancesSetMachineResourcesRequest(List<AcceleratorConfig> guestAccelerators) {
        this.guestAccelerators = guestAccelerators;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("guestAccelerators")) {
            return this.guestAccelerators;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AcceleratorConfig> getGuestAcceleratorsList() {
        return this.guestAccelerators;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstancesSetMachineResourcesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstancesSetMachineResourcesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstancesSetMachineResourcesRequest{guestAccelerators=" + this.guestAccelerators + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstancesSetMachineResourcesRequest) {
            InstancesSetMachineResourcesRequest that = (InstancesSetMachineResourcesRequest)o;
            return Objects.equals(this.guestAccelerators, that.getGuestAcceleratorsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.guestAccelerators);
    }

    public static class Builder {
        private List<AcceleratorConfig> guestAccelerators;

        Builder() {
        }

        public Builder mergeFrom(InstancesSetMachineResourcesRequest other) {
            if (other == InstancesSetMachineResourcesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getGuestAcceleratorsList() != null) {
                this.guestAccelerators = other.guestAccelerators;
            }
            return this;
        }

        Builder(InstancesSetMachineResourcesRequest source) {
            this.guestAccelerators = source.guestAccelerators;
        }

        public List<AcceleratorConfig> getGuestAcceleratorsList() {
            return this.guestAccelerators;
        }

        public Builder addAllGuestAccelerators(List<AcceleratorConfig> guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.addAll(guestAccelerators);
            return this;
        }

        public Builder addGuestAccelerators(AcceleratorConfig guestAccelerators) {
            if (this.guestAccelerators == null) {
                this.guestAccelerators = new LinkedList<AcceleratorConfig>();
            }
            this.guestAccelerators.add(guestAccelerators);
            return this;
        }

        public InstancesSetMachineResourcesRequest build() {
            return new InstancesSetMachineResourcesRequest(this.guestAccelerators);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllGuestAccelerators(this.guestAccelerators);
            return newBuilder;
        }
    }
}

