/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteFirewallHttpRequest;
import com.google.cloud.compute.v1.Firewall;
import com.google.cloud.compute.v1.FirewallList;
import com.google.cloud.compute.v1.FirewallSettings;
import com.google.cloud.compute.v1.GetFirewallHttpRequest;
import com.google.cloud.compute.v1.InsertFirewallHttpRequest;
import com.google.cloud.compute.v1.ListFirewallsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalFirewallName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateFirewallHttpRequest;
import com.google.cloud.compute.v1.stub.FirewallStub;
import com.google.cloud.compute.v1.stub.FirewallStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FirewallClient
implements BackgroundResource {
    private final FirewallSettings settings;
    private final FirewallStub stub;

    public static final FirewallClient create() throws IOException {
        return FirewallClient.create(FirewallSettings.newBuilder().build());
    }

    public static final FirewallClient create(FirewallSettings settings) throws IOException {
        return new FirewallClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FirewallClient create(FirewallStub stub) {
        return new FirewallClient(stub);
    }

    protected FirewallClient(FirewallSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirewallStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FirewallClient(FirewallStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirewallSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirewallStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteFirewall(ProjectGlobalFirewallName firewall) {
        DeleteFirewallHttpRequest request = DeleteFirewallHttpRequest.newBuilder().setFirewall(firewall == null ? null : firewall.toString()).build();
        return this.deleteFirewall(request);
    }

    @BetaApi
    public final Operation deleteFirewall(String firewall) {
        DeleteFirewallHttpRequest request = DeleteFirewallHttpRequest.newBuilder().setFirewall(firewall).build();
        return this.deleteFirewall(request);
    }

    @BetaApi
    public final Operation deleteFirewall(DeleteFirewallHttpRequest request) {
        return (Operation)this.deleteFirewallCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteFirewallHttpRequest, Operation> deleteFirewallCallable() {
        return this.stub.deleteFirewallCallable();
    }

    @BetaApi
    public final Firewall getFirewall(ProjectGlobalFirewallName firewall) {
        GetFirewallHttpRequest request = GetFirewallHttpRequest.newBuilder().setFirewall(firewall == null ? null : firewall.toString()).build();
        return this.getFirewall(request);
    }

    @BetaApi
    public final Firewall getFirewall(String firewall) {
        GetFirewallHttpRequest request = GetFirewallHttpRequest.newBuilder().setFirewall(firewall).build();
        return this.getFirewall(request);
    }

    @BetaApi
    public final Firewall getFirewall(GetFirewallHttpRequest request) {
        return (Firewall)this.getFirewallCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetFirewallHttpRequest, Firewall> getFirewallCallable() {
        return this.stub.getFirewallCallable();
    }

    @BetaApi
    public final Operation insertFirewall(ProjectName project, Firewall firewallResource) {
        InsertFirewallHttpRequest request = InsertFirewallHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setFirewallResource(firewallResource).build();
        return this.insertFirewall(request);
    }

    @BetaApi
    public final Operation insertFirewall(String project, Firewall firewallResource) {
        InsertFirewallHttpRequest request = InsertFirewallHttpRequest.newBuilder().setProject(project).setFirewallResource(firewallResource).build();
        return this.insertFirewall(request);
    }

    @BetaApi
    public final Operation insertFirewall(InsertFirewallHttpRequest request) {
        return (Operation)this.insertFirewallCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertFirewallHttpRequest, Operation> insertFirewallCallable() {
        return this.stub.insertFirewallCallable();
    }

    @BetaApi
    public final ListFirewallsPagedResponse listFirewalls(ProjectName project) {
        ListFirewallsHttpRequest request = ListFirewallsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listFirewalls(request);
    }

    @BetaApi
    public final ListFirewallsPagedResponse listFirewalls(String project) {
        ListFirewallsHttpRequest request = ListFirewallsHttpRequest.newBuilder().setProject(project).build();
        return this.listFirewalls(request);
    }

    @BetaApi
    public final ListFirewallsPagedResponse listFirewalls(ListFirewallsHttpRequest request) {
        return (ListFirewallsPagedResponse)((Object)this.listFirewallsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListFirewallsHttpRequest, ListFirewallsPagedResponse> listFirewallsPagedCallable() {
        return this.stub.listFirewallsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListFirewallsHttpRequest, FirewallList> listFirewallsCallable() {
        return this.stub.listFirewallsCallable();
    }

    @BetaApi
    public final Operation patchFirewall(ProjectGlobalFirewallName firewall, Firewall firewallResource, List<String> fieldMask) {
        PatchFirewallHttpRequest request = PatchFirewallHttpRequest.newBuilder().setFirewall(firewall == null ? null : firewall.toString()).setFirewallResource(firewallResource).addAllFieldMask(fieldMask).build();
        return this.patchFirewall(request);
    }

    @BetaApi
    public final Operation patchFirewall(String firewall, Firewall firewallResource, List<String> fieldMask) {
        PatchFirewallHttpRequest request = PatchFirewallHttpRequest.newBuilder().setFirewall(firewall).setFirewallResource(firewallResource).addAllFieldMask(fieldMask).build();
        return this.patchFirewall(request);
    }

    @BetaApi
    public final Operation patchFirewall(PatchFirewallHttpRequest request) {
        return (Operation)this.patchFirewallCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchFirewallHttpRequest, Operation> patchFirewallCallable() {
        return this.stub.patchFirewallCallable();
    }

    @BetaApi
    public final Operation updateFirewall(ProjectGlobalFirewallName firewall, Firewall firewallResource, List<String> fieldMask) {
        UpdateFirewallHttpRequest request = UpdateFirewallHttpRequest.newBuilder().setFirewall(firewall == null ? null : firewall.toString()).setFirewallResource(firewallResource).addAllFieldMask(fieldMask).build();
        return this.updateFirewall(request);
    }

    @BetaApi
    public final Operation updateFirewall(String firewall, Firewall firewallResource, List<String> fieldMask) {
        UpdateFirewallHttpRequest request = UpdateFirewallHttpRequest.newBuilder().setFirewall(firewall).setFirewallResource(firewallResource).addAllFieldMask(fieldMask).build();
        return this.updateFirewall(request);
    }

    @BetaApi
    public final Operation updateFirewall(UpdateFirewallHttpRequest request) {
        return (Operation)this.updateFirewallCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateFirewallHttpRequest, Operation> updateFirewallCallable() {
        return this.stub.updateFirewallCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFirewallsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFirewallsHttpRequest, FirewallList, Firewall, ListFirewallsPage, ListFirewallsFixedSizeCollection> {
        private ListFirewallsFixedSizeCollection(List<ListFirewallsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFirewallsFixedSizeCollection createEmptyCollection() {
            return new ListFirewallsFixedSizeCollection(null, 0);
        }

        protected ListFirewallsFixedSizeCollection createCollection(List<ListFirewallsPage> pages, int collectionSize) {
            return new ListFirewallsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFirewallsPage
    extends AbstractPage<ListFirewallsHttpRequest, FirewallList, Firewall, ListFirewallsPage> {
        private ListFirewallsPage(PageContext<ListFirewallsHttpRequest, FirewallList, Firewall> context, FirewallList response) {
            super(context, (Object)response);
        }

        private static ListFirewallsPage createEmptyPage() {
            return new ListFirewallsPage(null, null);
        }

        protected ListFirewallsPage createPage(PageContext<ListFirewallsHttpRequest, FirewallList, Firewall> context, FirewallList response) {
            return new ListFirewallsPage(context, response);
        }

        public ApiFuture<ListFirewallsPage> createPageAsync(PageContext<ListFirewallsHttpRequest, FirewallList, Firewall> context, ApiFuture<FirewallList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFirewallsPagedResponse
    extends AbstractPagedListResponse<ListFirewallsHttpRequest, FirewallList, Firewall, ListFirewallsPage, ListFirewallsFixedSizeCollection> {
        public static ApiFuture<ListFirewallsPagedResponse> createAsync(PageContext<ListFirewallsHttpRequest, FirewallList, Firewall> context, ApiFuture<FirewallList> futureResponse) {
            ApiFuture<ListFirewallsPage> futurePage = ListFirewallsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFirewallsPage, ListFirewallsPagedResponse>(){

                public ListFirewallsPagedResponse apply(ListFirewallsPage input) {
                    return new ListFirewallsPagedResponse(input);
                }
            });
        }

        private ListFirewallsPagedResponse(ListFirewallsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFirewallsFixedSizeCollection.createEmptyCollection());
        }
    }
}

