/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Commitment;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class CommitmentsScopedList
implements ApiMessage {
    private final List<Commitment> commitments;
    private final Warning warning;
    private static final CommitmentsScopedList DEFAULT_INSTANCE = new CommitmentsScopedList();

    private CommitmentsScopedList() {
        this.commitments = null;
        this.warning = null;
    }

    private CommitmentsScopedList(List<Commitment> commitments, Warning warning) {
        this.commitments = commitments;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("commitments")) {
            return this.commitments;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Commitment> getCommitmentsList() {
        return this.commitments;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CommitmentsScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static CommitmentsScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "CommitmentsScopedList{commitments=" + this.commitments + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CommitmentsScopedList) {
            CommitmentsScopedList that = (CommitmentsScopedList)o;
            return Objects.equals(this.commitments, that.getCommitmentsList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.commitments, this.warning);
    }

    public static class Builder {
        private List<Commitment> commitments;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(CommitmentsScopedList other) {
            if (other == CommitmentsScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getCommitmentsList() != null) {
                this.commitments = other.commitments;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(CommitmentsScopedList source) {
            this.commitments = source.commitments;
            this.warning = source.warning;
        }

        public List<Commitment> getCommitmentsList() {
            return this.commitments;
        }

        public Builder addAllCommitments(List<Commitment> commitments) {
            if (this.commitments == null) {
                this.commitments = new LinkedList<Commitment>();
            }
            this.commitments.addAll(commitments);
            return this;
        }

        public Builder addCommitments(Commitment commitments) {
            if (this.commitments == null) {
                this.commitments = new LinkedList<Commitment>();
            }
            this.commitments.add(commitments);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public CommitmentsScopedList build() {
            return new CommitmentsScopedList(this.commitments, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllCommitments(this.commitments);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

