/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Snapshot;
import com.google.cloud.compute.deprecated.DiskId;
import com.google.cloud.compute.deprecated.LicenseId;
import com.google.cloud.compute.deprecated.SnapshotId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SnapshotInfo
implements Serializable {
    static final Function<Snapshot, SnapshotInfo> FROM_PB_FUNCTION = new Function<Snapshot, SnapshotInfo>(){

        public SnapshotInfo apply(Snapshot pb) {
            return SnapshotInfo.fromPb(pb);
        }
    };
    static final Function<SnapshotInfo, Snapshot> TO_PB_FUNCTION = new Function<SnapshotInfo, Snapshot>(){

        public Snapshot apply(SnapshotInfo snapshot) {
            return snapshot.toPb();
        }
    };
    private static final long serialVersionUID = 1065513502131159769L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final SnapshotId snapshotId;
    private final Long creationTimestamp;
    private final String description;
    private final Status status;
    private final Long diskSizeGb;
    private final List<LicenseId> licenses;
    private final DiskId sourceDisk;
    private final String sourceDiskId;
    private final Long storageBytes;
    private final StorageBytesStatus storageBytesStatus;

    SnapshotInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.snapshotId = (SnapshotId)Preconditions.checkNotNull((Object)builder.snapshotId);
        this.description = builder.description;
        this.status = builder.status;
        this.diskSizeGb = builder.diskSizeGb;
        this.licenses = builder.licenses;
        this.sourceDisk = builder.sourceDisk;
        this.sourceDiskId = builder.sourceDiskId;
        this.storageBytes = builder.storageBytes;
        this.storageBytesStatus = builder.storageBytesStatus;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public String getDescription() {
        return this.description;
    }

    public List<LicenseId> getLicenses() {
        return this.licenses;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public DiskId getSourceDisk() {
        return this.sourceDisk;
    }

    public String getSourceDiskId() {
        return this.sourceDiskId;
    }

    public Long getStorageBytes() {
        return this.storageBytes;
    }

    public StorageBytesStatus getStorageBytesStatus() {
        return this.storageBytesStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("snapshotId", (Object)this.snapshotId).add("description", (Object)this.description).add("status", (Object)this.status).add("diskSizeGb", (Object)this.diskSizeGb).add("licenses", this.licenses).add("sourceDisk", (Object)this.sourceDisk).add("sourceDiskId", (Object)this.sourceDiskId).add("storageBytes", (Object)this.storageBytes).add("storageBytesStatus", (Object)this.storageBytesStatus).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.generatedId, this.creationTimestamp, this.snapshotId, this.description, this.status, this.diskSizeGb, this.licenses, this.sourceDisk, this.sourceDiskId, this.storageBytes, this.storageBytesStatus});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SnapshotInfo.class) && Objects.equals(this.toPb(), ((SnapshotInfo)obj).toPb());
    }

    SnapshotInfo setProjectId(String projectId) {
        return this.toBuilder().setSnapshotId(this.snapshotId.setProjectId(projectId)).setSourceDisk(this.sourceDisk.setProjectId(projectId)).build();
    }

    Snapshot toPb() {
        Snapshot snapshotPb = new Snapshot();
        if (this.generatedId != null) {
            snapshotPb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            snapshotPb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        snapshotPb.setName(this.snapshotId.getSnapshot());
        snapshotPb.setDescription(this.description);
        snapshotPb.setSelfLink(this.snapshotId.getSelfLink());
        if (this.status != null) {
            snapshotPb.setStatus(this.status.name());
        }
        snapshotPb.setDiskSizeGb(this.diskSizeGb);
        if (this.licenses != null) {
            snapshotPb.setLicenses(Lists.transform(this.licenses, LicenseId.TO_URL_FUNCTION));
        }
        if (this.sourceDisk != null) {
            snapshotPb.setSourceDisk(this.sourceDisk.getSelfLink());
        }
        snapshotPb.setSourceDiskId(this.sourceDiskId);
        snapshotPb.setStorageBytes(this.storageBytes);
        if (this.storageBytesStatus != null) {
            snapshotPb.setStorageBytesStatus(this.storageBytesStatus.name());
        }
        return snapshotPb;
    }

    public static Builder newBuilder(SnapshotId snapshotId, DiskId source) {
        return new BuilderImpl().setSnapshotId(snapshotId).setSourceDisk(source);
    }

    public static SnapshotInfo of(SnapshotId snapshotId, DiskId source) {
        return SnapshotInfo.newBuilder(snapshotId, source).build();
    }

    static SnapshotInfo fromPb(Snapshot snapshotPb) {
        return new BuilderImpl(snapshotPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private Long creationTimestamp;
        private SnapshotId snapshotId;
        private String description;
        private Status status;
        private Long diskSizeGb;
        private List<LicenseId> licenses;
        private DiskId sourceDisk;
        private String sourceDiskId;
        private Long storageBytes;
        private StorageBytesStatus storageBytesStatus;

        BuilderImpl() {
        }

        BuilderImpl(SnapshotInfo snapshotInfo) {
            this.generatedId = snapshotInfo.generatedId;
            this.creationTimestamp = snapshotInfo.creationTimestamp;
            this.snapshotId = snapshotInfo.snapshotId;
            this.description = snapshotInfo.description;
            this.status = snapshotInfo.status;
            this.diskSizeGb = snapshotInfo.diskSizeGb;
            this.licenses = snapshotInfo.licenses;
            this.sourceDisk = snapshotInfo.sourceDisk;
            this.sourceDiskId = snapshotInfo.sourceDiskId;
            this.storageBytes = snapshotInfo.storageBytes;
            this.storageBytesStatus = snapshotInfo.storageBytesStatus;
        }

        BuilderImpl(Snapshot snapshotPb) {
            if (snapshotPb.getId() != null) {
                this.generatedId = snapshotPb.getId().toString();
            }
            if (snapshotPb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(snapshotPb.getCreationTimestamp());
            }
            this.snapshotId = SnapshotId.fromUrl(snapshotPb.getSelfLink());
            this.description = snapshotPb.getDescription();
            if (snapshotPb.getStatus() != null) {
                this.status = Status.valueOf(snapshotPb.getStatus());
            }
            this.diskSizeGb = snapshotPb.getDiskSizeGb();
            if (snapshotPb.getLicenses() != null) {
                this.licenses = Lists.transform((List)snapshotPb.getLicenses(), LicenseId.FROM_URL_FUNCTION);
            }
            if (snapshotPb.getSourceDisk() != null) {
                this.sourceDisk = DiskId.fromUrl(snapshotPb.getSourceDisk());
            }
            this.sourceDiskId = snapshotPb.getSourceDiskId();
            this.storageBytes = snapshotPb.getStorageBytes();
            if (snapshotPb.getStorageBytesStatus() != null) {
                this.storageBytesStatus = StorageBytesStatus.valueOf(snapshotPb.getStorageBytesStatus());
            }
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        BuilderImpl setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public BuilderImpl setSnapshotId(SnapshotId snapshotId) {
            this.snapshotId = (SnapshotId)Preconditions.checkNotNull((Object)snapshotId);
            return this;
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        BuilderImpl setStatus(Status status) {
            this.status = status;
            return this;
        }

        @Override
        BuilderImpl setDiskSizeGb(Long diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        @Override
        BuilderImpl setLicenses(List<LicenseId> licenses) {
            this.licenses = licenses != null ? ImmutableList.copyOf(licenses) : null;
            return this;
        }

        @Override
        public BuilderImpl setSourceDisk(DiskId sourceDisk) {
            this.sourceDisk = (DiskId)Preconditions.checkNotNull((Object)sourceDisk);
            return this;
        }

        @Override
        BuilderImpl setSourceDiskId(String sourceDiskId) {
            this.sourceDiskId = sourceDiskId;
            return this;
        }

        @Override
        BuilderImpl setStorageBytes(Long storageBytes) {
            this.storageBytes = storageBytes;
            return this;
        }

        @Override
        BuilderImpl setStorageBytesStatus(StorageBytesStatus storageBytesStatus) {
            this.storageBytesStatus = storageBytesStatus;
            return this;
        }

        @Override
        public SnapshotInfo build() {
            return new SnapshotInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setGeneratedId(String var1);

        abstract Builder setCreationTimestamp(Long var1);

        public abstract Builder setSnapshotId(SnapshotId var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setStatus(Status var1);

        abstract Builder setDiskSizeGb(Long var1);

        abstract Builder setLicenses(List<LicenseId> var1);

        public abstract Builder setSourceDisk(DiskId var1);

        abstract Builder setSourceDiskId(String var1);

        abstract Builder setStorageBytes(Long var1);

        abstract Builder setStorageBytesStatus(StorageBytesStatus var1);

        public abstract SnapshotInfo build();
    }

    public static enum StorageBytesStatus {
        UPDATING,
        UP_TO_DATE;

    }

    public static enum Status {
        CREATING,
        DELETING,
        FAILED,
        READY,
        UPLOADING;

    }
}

