/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.deprecated.NetworkConfiguration;
import com.google.cloud.compute.deprecated.NetworkId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class NetworkInfo
implements Serializable {
    static final Function<Network, NetworkInfo> FROM_PB_FUNCTION = new Function<Network, NetworkInfo>(){

        public NetworkInfo apply(Network pb) {
            return NetworkInfo.fromPb(pb);
        }
    };
    static final Function<NetworkInfo, Network> TO_PB_FUNCTION = new Function<NetworkInfo, Network>(){

        public Network apply(NetworkInfo network) {
            return network.toPb();
        }
    };
    private static final long serialVersionUID = 4336912581538114026L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final NetworkId networkId;
    private final Long creationTimestamp;
    private final String description;
    private final NetworkConfiguration configuration;

    NetworkInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.networkId = builder.networkId;
        this.description = builder.description;
        this.configuration = builder.configuration;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public String getDescription() {
        return this.description;
    }

    public <T extends NetworkConfiguration> T getConfiguration() {
        return (T)this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("networkId", (Object)this.networkId).add("description", (Object)this.description).add("configuration", (Object)this.configuration).toString();
    }

    public int hashCode() {
        return Objects.hash(this.generatedId, this.networkId, this.creationTimestamp, this.description, this.configuration);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(NetworkInfo.class) && Objects.equals(this.toPb(), ((NetworkInfo)obj).toPb());
    }

    NetworkInfo setProjectId(String projectId) {
        return this.toBuilder().setNetworkId(this.networkId.setProjectId(projectId)).build();
    }

    Network toPb() {
        Network networkPb = this.configuration.toPb();
        if (this.generatedId != null) {
            networkPb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            networkPb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        networkPb.setName(this.networkId.getNetwork());
        networkPb.setDescription(this.description);
        networkPb.setSelfLink(this.networkId.getSelfLink());
        return networkPb;
    }

    public static Builder newBuilder(NetworkId networkId, NetworkConfiguration configuration) {
        return new BuilderImpl(networkId, configuration);
    }

    public static NetworkInfo of(NetworkId networkId, NetworkConfiguration configuration) {
        return NetworkInfo.newBuilder(networkId, configuration).build();
    }

    static NetworkInfo fromPb(Network networkPb) {
        return new BuilderImpl(networkPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private NetworkId networkId;
        private Long creationTimestamp;
        private String description;
        private NetworkConfiguration configuration;

        BuilderImpl(NetworkId networkId, NetworkConfiguration configuration) {
            this.networkId = (NetworkId)Preconditions.checkNotNull((Object)networkId);
            this.configuration = (NetworkConfiguration)Preconditions.checkNotNull((Object)configuration);
        }

        BuilderImpl(NetworkInfo networkInfo) {
            this.generatedId = networkInfo.generatedId;
            this.creationTimestamp = networkInfo.creationTimestamp;
            this.networkId = networkInfo.networkId;
            this.description = networkInfo.description;
            this.configuration = networkInfo.configuration;
        }

        BuilderImpl(Network networkPb) {
            if (networkPb.getId() != null) {
                this.generatedId = networkPb.getId().toString();
            }
            if (networkPb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(networkPb.getCreationTimestamp());
            }
            this.networkId = NetworkId.fromUrl(networkPb.getSelfLink());
            this.description = networkPb.getDescription();
            this.configuration = NetworkConfiguration.fromPb(networkPb);
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        BuilderImpl setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public BuilderImpl setNetworkId(NetworkId networkId) {
            this.networkId = (NetworkId)Preconditions.checkNotNull((Object)networkId);
            return this;
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BuilderImpl setConfiguration(NetworkConfiguration configuration) {
            this.configuration = (NetworkConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public NetworkInfo build() {
            return new NetworkInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setGeneratedId(String var1);

        abstract Builder setCreationTimestamp(Long var1);

        public abstract Builder setNetworkId(NetworkId var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setConfiguration(NetworkConfiguration var1);

        public abstract NetworkInfo build();
    }
}

