/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddNodesNodeGroupHttpRequest;
import com.google.cloud.compute.v1.AggregatedListNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.DeleteNodeGroupHttpRequest;
import com.google.cloud.compute.v1.DeleteNodesNodeGroupHttpRequest;
import com.google.cloud.compute.v1.GetNodeGroupHttpRequest;
import com.google.cloud.compute.v1.InsertNodeGroupHttpRequest;
import com.google.cloud.compute.v1.ListNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.ListNodesNodeGroupsHttpRequest;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.NodeGroupAggregatedList;
import com.google.cloud.compute.v1.NodeGroupClient;
import com.google.cloud.compute.v1.NodeGroupList;
import com.google.cloud.compute.v1.NodeGroupNode;
import com.google.cloud.compute.v1.NodeGroupsListNodes;
import com.google.cloud.compute.v1.NodeGroupsScopedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetNodeTemplateNodeGroupHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonNodeGroupStub;
import com.google.cloud.compute.v1.stub.NodeGroupStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NodeGroupStubSettings
extends StubSettings<NodeGroupStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddNodesNodeGroupHttpRequest, Operation> addNodesNodeGroupSettings;
    private final PagedCallSettings<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse> aggregatedListNodeGroupsSettings;
    private final UnaryCallSettings<DeleteNodeGroupHttpRequest, Operation> deleteNodeGroupSettings;
    private final UnaryCallSettings<DeleteNodesNodeGroupHttpRequest, Operation> deleteNodesNodeGroupSettings;
    private final UnaryCallSettings<GetNodeGroupHttpRequest, NodeGroup> getNodeGroupSettings;
    private final UnaryCallSettings<InsertNodeGroupHttpRequest, Operation> insertNodeGroupSettings;
    private final PagedCallSettings<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse> listNodeGroupsSettings;
    private final PagedCallSettings<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse> listNodesNodeGroupsSettings;
    private final UnaryCallSettings<SetNodeTemplateNodeGroupHttpRequest, Operation> setNodeTemplateNodeGroupSettings;
    private static final PagedListDescriptor<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList> AGGREGATED_LIST_NODE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeGroupsHttpRequest injectToken(AggregatedListNodeGroupsHttpRequest payload, String token) {
            return AggregatedListNodeGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListNodeGroupsHttpRequest injectPageSize(AggregatedListNodeGroupsHttpRequest payload, int pageSize) {
            return AggregatedListNodeGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeGroupsScopedList> extractResources(NodeGroupAggregatedList payload) {
            return payload.getItemsMap().values();
        }
    };
    private static final PagedListDescriptor<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup> LIST_NODE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeGroupsHttpRequest injectToken(ListNodeGroupsHttpRequest payload, String token) {
            return ListNodeGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNodeGroupsHttpRequest injectPageSize(ListNodeGroupsHttpRequest payload, int pageSize) {
            return ListNodeGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeGroup> extractResources(NodeGroupList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode> LIST_NODES_NODE_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode>(){

        public String emptyToken() {
            return "";
        }

        public ListNodesNodeGroupsHttpRequest injectToken(ListNodesNodeGroupsHttpRequest payload, String token) {
            return ListNodesNodeGroupsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNodesNodeGroupsHttpRequest injectPageSize(ListNodesNodeGroupsHttpRequest payload, int pageSize) {
            return ListNodesNodeGroupsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodesNodeGroupsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeGroupsListNodes payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeGroupNode> extractResources(NodeGroupsListNodes payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse> AGGREGATED_LIST_NODE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse>(){

        public ApiFuture<NodeGroupClient.AggregatedListNodeGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList> callable, AggregatedListNodeGroupsHttpRequest request, ApiCallContext context, ApiFuture<NodeGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_NODE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupClient.AggregatedListNodeGroupsPagedResponse.createAsync((PageContext<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse> LIST_NODE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse>(){

        public ApiFuture<NodeGroupClient.ListNodeGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeGroupsHttpRequest, NodeGroupList> callable, ListNodeGroupsHttpRequest request, ApiCallContext context, ApiFuture<NodeGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupClient.ListNodeGroupsPagedResponse.createAsync((PageContext<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse> LIST_NODES_NODE_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse>(){

        public ApiFuture<NodeGroupClient.ListNodesNodeGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes> callable, ListNodesNodeGroupsHttpRequest request, ApiCallContext context, ApiFuture<NodeGroupsListNodes> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NODES_NODE_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeGroupClient.ListNodesNodeGroupsPagedResponse.createAsync((PageContext<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupNode>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddNodesNodeGroupHttpRequest, Operation> addNodesNodeGroupSettings() {
        return this.addNodesNodeGroupSettings;
    }

    public PagedCallSettings<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse> aggregatedListNodeGroupsSettings() {
        return this.aggregatedListNodeGroupsSettings;
    }

    public UnaryCallSettings<DeleteNodeGroupHttpRequest, Operation> deleteNodeGroupSettings() {
        return this.deleteNodeGroupSettings;
    }

    public UnaryCallSettings<DeleteNodesNodeGroupHttpRequest, Operation> deleteNodesNodeGroupSettings() {
        return this.deleteNodesNodeGroupSettings;
    }

    public UnaryCallSettings<GetNodeGroupHttpRequest, NodeGroup> getNodeGroupSettings() {
        return this.getNodeGroupSettings;
    }

    public UnaryCallSettings<InsertNodeGroupHttpRequest, Operation> insertNodeGroupSettings() {
        return this.insertNodeGroupSettings;
    }

    public PagedCallSettings<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse> listNodeGroupsSettings() {
        return this.listNodeGroupsSettings;
    }

    public PagedCallSettings<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse> listNodesNodeGroupsSettings() {
        return this.listNodesNodeGroupsSettings;
    }

    public UnaryCallSettings<SetNodeTemplateNodeGroupHttpRequest, Operation> setNodeTemplateNodeGroupSettings() {
        return this.setNodeTemplateNodeGroupSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeGroupStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeGroupStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeGroupStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeGroupStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeGroupStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addNodesNodeGroupSettings = settingsBuilder.addNodesNodeGroupSettings().build();
        this.aggregatedListNodeGroupsSettings = settingsBuilder.aggregatedListNodeGroupsSettings().build();
        this.deleteNodeGroupSettings = settingsBuilder.deleteNodeGroupSettings().build();
        this.deleteNodesNodeGroupSettings = settingsBuilder.deleteNodesNodeGroupSettings().build();
        this.getNodeGroupSettings = settingsBuilder.getNodeGroupSettings().build();
        this.insertNodeGroupSettings = settingsBuilder.insertNodeGroupSettings().build();
        this.listNodeGroupsSettings = settingsBuilder.listNodeGroupsSettings().build();
        this.listNodesNodeGroupsSettings = settingsBuilder.listNodesNodeGroupsSettings().build();
        this.setNodeTemplateNodeGroupSettings = settingsBuilder.setNodeTemplateNodeGroupSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeGroupStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddNodesNodeGroupHttpRequest, Operation> addNodesNodeGroupSettings;
        private final PagedCallSettings.Builder<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse> aggregatedListNodeGroupsSettings;
        private final UnaryCallSettings.Builder<DeleteNodeGroupHttpRequest, Operation> deleteNodeGroupSettings;
        private final UnaryCallSettings.Builder<DeleteNodesNodeGroupHttpRequest, Operation> deleteNodesNodeGroupSettings;
        private final UnaryCallSettings.Builder<GetNodeGroupHttpRequest, NodeGroup> getNodeGroupSettings;
        private final UnaryCallSettings.Builder<InsertNodeGroupHttpRequest, Operation> insertNodeGroupSettings;
        private final PagedCallSettings.Builder<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse> listNodeGroupsSettings;
        private final PagedCallSettings.Builder<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse> listNodesNodeGroupsSettings;
        private final UnaryCallSettings.Builder<SetNodeTemplateNodeGroupHttpRequest, Operation> setNodeTemplateNodeGroupSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addNodesNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListNodeGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_NODE_GROUPS_PAGE_STR_FACT);
            this.deleteNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNodesNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNodeGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODE_GROUPS_PAGE_STR_FACT);
            this.listNodesNodeGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NODES_NODE_GROUPS_PAGE_STR_FACT);
            this.setNodeTemplateNodeGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addNodesNodeGroupSettings, this.aggregatedListNodeGroupsSettings, this.deleteNodeGroupSettings, this.deleteNodesNodeGroupSettings, this.getNodeGroupSettings, this.insertNodeGroupSettings, this.listNodeGroupsSettings, this.listNodesNodeGroupsSettings, this.setNodeTemplateNodeGroupSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeGroupStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeGroupStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeGroupStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeGroupStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addNodesNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListNodeGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteNodesNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNodeGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNodesNodeGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setNodeTemplateNodeGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NodeGroupStubSettings settings) {
            super((StubSettings)settings);
            this.addNodesNodeGroupSettings = settings.addNodesNodeGroupSettings.toBuilder();
            this.aggregatedListNodeGroupsSettings = settings.aggregatedListNodeGroupsSettings.toBuilder();
            this.deleteNodeGroupSettings = settings.deleteNodeGroupSettings.toBuilder();
            this.deleteNodesNodeGroupSettings = settings.deleteNodesNodeGroupSettings.toBuilder();
            this.getNodeGroupSettings = settings.getNodeGroupSettings.toBuilder();
            this.insertNodeGroupSettings = settings.insertNodeGroupSettings.toBuilder();
            this.listNodeGroupsSettings = settings.listNodeGroupsSettings.toBuilder();
            this.listNodesNodeGroupsSettings = settings.listNodesNodeGroupsSettings.toBuilder();
            this.setNodeTemplateNodeGroupSettings = settings.setNodeTemplateNodeGroupSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addNodesNodeGroupSettings, this.aggregatedListNodeGroupsSettings, this.deleteNodeGroupSettings, this.deleteNodesNodeGroupSettings, this.getNodeGroupSettings, this.insertNodeGroupSettings, this.listNodeGroupsSettings, this.listNodesNodeGroupsSettings, this.setNodeTemplateNodeGroupSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddNodesNodeGroupHttpRequest, Operation> addNodesNodeGroupSettings() {
            return this.addNodesNodeGroupSettings;
        }

        public PagedCallSettings.Builder<AggregatedListNodeGroupsHttpRequest, NodeGroupAggregatedList, NodeGroupClient.AggregatedListNodeGroupsPagedResponse> aggregatedListNodeGroupsSettings() {
            return this.aggregatedListNodeGroupsSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeGroupHttpRequest, Operation> deleteNodeGroupSettings() {
            return this.deleteNodeGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodesNodeGroupHttpRequest, Operation> deleteNodesNodeGroupSettings() {
            return this.deleteNodesNodeGroupSettings;
        }

        public UnaryCallSettings.Builder<GetNodeGroupHttpRequest, NodeGroup> getNodeGroupSettings() {
            return this.getNodeGroupSettings;
        }

        public UnaryCallSettings.Builder<InsertNodeGroupHttpRequest, Operation> insertNodeGroupSettings() {
            return this.insertNodeGroupSettings;
        }

        public PagedCallSettings.Builder<ListNodeGroupsHttpRequest, NodeGroupList, NodeGroupClient.ListNodeGroupsPagedResponse> listNodeGroupsSettings() {
            return this.listNodeGroupsSettings;
        }

        public PagedCallSettings.Builder<ListNodesNodeGroupsHttpRequest, NodeGroupsListNodes, NodeGroupClient.ListNodesNodeGroupsPagedResponse> listNodesNodeGroupsSettings() {
            return this.listNodesNodeGroupsSettings;
        }

        public UnaryCallSettings.Builder<SetNodeTemplateNodeGroupHttpRequest, Operation> setNodeTemplateNodeGroupSettings() {
            return this.setNodeTemplateNodeGroupSettings;
        }

        public NodeGroupStubSettings build() throws IOException {
            return new NodeGroupStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

