/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectLocationRegionInfo
implements ApiMessage {
    private final String expectedRttMs;
    private final String locationPresence;
    private final String region;
    private static final InterconnectLocationRegionInfo DEFAULT_INSTANCE = new InterconnectLocationRegionInfo();

    private InterconnectLocationRegionInfo() {
        this.expectedRttMs = null;
        this.locationPresence = null;
        this.region = null;
    }

    private InterconnectLocationRegionInfo(String expectedRttMs, String locationPresence, String region) {
        this.expectedRttMs = expectedRttMs;
        this.locationPresence = locationPresence;
        this.region = region;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("expectedRttMs")) {
            return this.expectedRttMs;
        }
        if (fieldName.equals("locationPresence")) {
            return this.locationPresence;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getExpectedRttMs() {
        return this.expectedRttMs;
    }

    public String getLocationPresence() {
        return this.locationPresence;
    }

    public String getRegion() {
        return this.region;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectLocationRegionInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectLocationRegionInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectLocationRegionInfo{expectedRttMs=" + this.expectedRttMs + ", locationPresence=" + this.locationPresence + ", region=" + this.region + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectLocationRegionInfo) {
            InterconnectLocationRegionInfo that = (InterconnectLocationRegionInfo)o;
            return Objects.equals(this.expectedRttMs, that.getExpectedRttMs()) && Objects.equals(this.locationPresence, that.getLocationPresence()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.expectedRttMs, this.locationPresence, this.region);
    }

    public static class Builder {
        private String expectedRttMs;
        private String locationPresence;
        private String region;

        Builder() {
        }

        public Builder mergeFrom(InterconnectLocationRegionInfo other) {
            if (other == InterconnectLocationRegionInfo.getDefaultInstance()) {
                return this;
            }
            if (other.getExpectedRttMs() != null) {
                this.expectedRttMs = other.expectedRttMs;
            }
            if (other.getLocationPresence() != null) {
                this.locationPresence = other.locationPresence;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            return this;
        }

        Builder(InterconnectLocationRegionInfo source) {
            this.expectedRttMs = source.expectedRttMs;
            this.locationPresence = source.locationPresence;
            this.region = source.region;
        }

        public String getExpectedRttMs() {
            return this.expectedRttMs;
        }

        public Builder setExpectedRttMs(String expectedRttMs) {
            this.expectedRttMs = expectedRttMs;
            return this;
        }

        public String getLocationPresence() {
            return this.locationPresence;
        }

        public Builder setLocationPresence(String locationPresence) {
            this.locationPresence = locationPresence;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public InterconnectLocationRegionInfo build() {
            return new InterconnectLocationRegionInfo(this.expectedRttMs, this.locationPresence, this.region);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setExpectedRttMs(this.expectedRttMs);
            newBuilder.setLocationPresence(this.locationPresence);
            newBuilder.setRegion(this.region);
            return newBuilder;
        }
    }
}

