/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.OperationId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GlobalOperationId
extends OperationId {
    private static final String REGEX = ".*?projects/([^/]+)/global/operations/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/operations/([^/]+)");
    private static final long serialVersionUID = 3945756772641577962L;

    private GlobalOperationId(String project, String operation) {
        super(project, operation);
    }

    @Override
    public OperationId.Type getType() {
        return OperationId.Type.GLOBAL;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/global/operations/" + this.getOperation();
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GlobalOperationId && this.baseEquals((GlobalOperationId)obj);
    }

    @Override
    GlobalOperationId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return GlobalOperationId.of(projectId, this.getOperation());
    }

    public static GlobalOperationId of(String operation) {
        return new GlobalOperationId(null, operation);
    }

    public static GlobalOperationId of(String project, String operation) {
        return new GlobalOperationId(project, operation);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static GlobalOperationId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid global operation URL");
        }
        return GlobalOperationId.of(matcher.group(1), matcher.group(2));
    }
}

