/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddPeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.DeleteNetworkHttpRequest;
import com.google.cloud.compute.v1.GetNetworkHttpRequest;
import com.google.cloud.compute.v1.InsertNetworkHttpRequest;
import com.google.cloud.compute.v1.ListNetworksHttpRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkClient;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkHttpRequest;
import com.google.cloud.compute.v1.RemovePeeringNetworkHttpRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonNetworkStub;
import com.google.cloud.compute.v1.stub.NetworkStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NetworkStubSettings
extends StubSettings<NetworkStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkSettings;
    private final UnaryCallSettings<DeleteNetworkHttpRequest, Operation> deleteNetworkSettings;
    private final UnaryCallSettings<GetNetworkHttpRequest, Network> getNetworkSettings;
    private final UnaryCallSettings<InsertNetworkHttpRequest, Operation> insertNetworkSettings;
    private final PagedCallSettings<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse> listNetworksSettings;
    private final UnaryCallSettings<PatchNetworkHttpRequest, Operation> patchNetworkSettings;
    private final UnaryCallSettings<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkSettings;
    private final UnaryCallSettings<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkSettings;
    private static final PagedListDescriptor<ListNetworksHttpRequest, NetworkList, Network> LIST_NETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksHttpRequest, NetworkList, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksHttpRequest injectToken(ListNetworksHttpRequest payload, String token) {
            return ListNetworksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListNetworksHttpRequest injectPageSize(ListNetworksHttpRequest payload, int pageSize) {
            return ListNetworksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(NetworkList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse> LIST_NETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse>(){

        public ApiFuture<NetworkClient.ListNetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksHttpRequest, NetworkList> callable, ListNetworksHttpRequest request, ApiCallContext context, ApiFuture<NetworkList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkClient.ListNetworksPagedResponse.createAsync((PageContext<ListNetworksHttpRequest, NetworkList, Network>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkSettings() {
        return this.addPeeringNetworkSettings;
    }

    public UnaryCallSettings<DeleteNetworkHttpRequest, Operation> deleteNetworkSettings() {
        return this.deleteNetworkSettings;
    }

    public UnaryCallSettings<GetNetworkHttpRequest, Network> getNetworkSettings() {
        return this.getNetworkSettings;
    }

    public UnaryCallSettings<InsertNetworkHttpRequest, Operation> insertNetworkSettings() {
        return this.insertNetworkSettings;
    }

    public PagedCallSettings<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse> listNetworksSettings() {
        return this.listNetworksSettings;
    }

    public UnaryCallSettings<PatchNetworkHttpRequest, Operation> patchNetworkSettings() {
        return this.patchNetworkSettings;
    }

    public UnaryCallSettings<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkSettings() {
        return this.removePeeringNetworkSettings;
    }

    public UnaryCallSettings<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkSettings() {
        return this.switchToCustomModeNetworkSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworkStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworkStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworkStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addPeeringNetworkSettings = settingsBuilder.addPeeringNetworkSettings().build();
        this.deleteNetworkSettings = settingsBuilder.deleteNetworkSettings().build();
        this.getNetworkSettings = settingsBuilder.getNetworkSettings().build();
        this.insertNetworkSettings = settingsBuilder.insertNetworkSettings().build();
        this.listNetworksSettings = settingsBuilder.listNetworksSettings().build();
        this.patchNetworkSettings = settingsBuilder.patchNetworkSettings().build();
        this.removePeeringNetworkSettings = settingsBuilder.removePeeringNetworkSettings().build();
        this.switchToCustomModeNetworkSettings = settingsBuilder.switchToCustomModeNetworkSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworkStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkHttpRequest, Operation> deleteNetworkSettings;
        private final UnaryCallSettings.Builder<GetNetworkHttpRequest, Network> getNetworkSettings;
        private final UnaryCallSettings.Builder<InsertNetworkHttpRequest, Operation> insertNetworkSettings;
        private final PagedCallSettings.Builder<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse> listNetworksSettings;
        private final UnaryCallSettings.Builder<PatchNetworkHttpRequest, Operation> patchNetworkSettings;
        private final UnaryCallSettings.Builder<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkSettings;
        private final UnaryCallSettings.Builder<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addPeeringNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORKS_PAGE_STR_FACT);
            this.patchNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removePeeringNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.switchToCustomModeNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringNetworkSettings, this.deleteNetworkSettings, this.getNetworkSettings, this.insertNetworkSettings, this.listNetworksSettings, this.patchNetworkSettings, this.removePeeringNetworkSettings, this.switchToCustomModeNetworkSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworkStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworkStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NetworkStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addPeeringNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listNetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removePeeringNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.switchToCustomModeNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NetworkStubSettings settings) {
            super((StubSettings)settings);
            this.addPeeringNetworkSettings = settings.addPeeringNetworkSettings.toBuilder();
            this.deleteNetworkSettings = settings.deleteNetworkSettings.toBuilder();
            this.getNetworkSettings = settings.getNetworkSettings.toBuilder();
            this.insertNetworkSettings = settings.insertNetworkSettings.toBuilder();
            this.listNetworksSettings = settings.listNetworksSettings.toBuilder();
            this.patchNetworkSettings = settings.patchNetworkSettings.toBuilder();
            this.removePeeringNetworkSettings = settings.removePeeringNetworkSettings.toBuilder();
            this.switchToCustomModeNetworkSettings = settings.switchToCustomModeNetworkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringNetworkSettings, this.deleteNetworkSettings, this.getNetworkSettings, this.insertNetworkSettings, this.listNetworksSettings, this.patchNetworkSettings, this.removePeeringNetworkSettings, this.switchToCustomModeNetworkSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddPeeringNetworkHttpRequest, Operation> addPeeringNetworkSettings() {
            return this.addPeeringNetworkSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkHttpRequest, Operation> deleteNetworkSettings() {
            return this.deleteNetworkSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkHttpRequest, Network> getNetworkSettings() {
            return this.getNetworkSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkHttpRequest, Operation> insertNetworkSettings() {
            return this.insertNetworkSettings;
        }

        public PagedCallSettings.Builder<ListNetworksHttpRequest, NetworkList, NetworkClient.ListNetworksPagedResponse> listNetworksSettings() {
            return this.listNetworksSettings;
        }

        public UnaryCallSettings.Builder<PatchNetworkHttpRequest, Operation> patchNetworkSettings() {
            return this.patchNetworkSettings;
        }

        public UnaryCallSettings.Builder<RemovePeeringNetworkHttpRequest, Operation> removePeeringNetworkSettings() {
            return this.removePeeringNetworkSettings;
        }

        public UnaryCallSettings.Builder<SwitchToCustomModeNetworkHttpRequest, Operation> switchToCustomModeNetworkSettings() {
            return this.switchToCustomModeNetworkSettings;
        }

        public NetworkStubSettings build() throws IOException {
            return new NetworkStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

