/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SubnetworkSecondaryRange;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Subnetwork
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final Boolean enableFlowLogs;
    private final String fingerprint;
    private final String gatewayAddress;
    private final String id;
    private final String ipCidrRange;
    private final String kind;
    private final String name;
    private final String network;
    private final Boolean privateIpGoogleAccess;
    private final String region;
    private final List<SubnetworkSecondaryRange> secondaryIpRanges;
    private final String selfLink;
    private static final Subnetwork DEFAULT_INSTANCE = new Subnetwork();

    private Subnetwork() {
        this.creationTimestamp = null;
        this.description = null;
        this.enableFlowLogs = null;
        this.fingerprint = null;
        this.gatewayAddress = null;
        this.id = null;
        this.ipCidrRange = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.privateIpGoogleAccess = null;
        this.region = null;
        this.secondaryIpRanges = null;
        this.selfLink = null;
    }

    private Subnetwork(String creationTimestamp, String description, Boolean enableFlowLogs, String fingerprint, String gatewayAddress, String id, String ipCidrRange, String kind, String name, String network, Boolean privateIpGoogleAccess, String region, List<SubnetworkSecondaryRange> secondaryIpRanges, String selfLink) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.enableFlowLogs = enableFlowLogs;
        this.fingerprint = fingerprint;
        this.gatewayAddress = gatewayAddress;
        this.id = id;
        this.ipCidrRange = ipCidrRange;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.privateIpGoogleAccess = privateIpGoogleAccess;
        this.region = region;
        this.secondaryIpRanges = secondaryIpRanges;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("enableFlowLogs")) {
            return this.enableFlowLogs;
        }
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("gatewayAddress")) {
            return this.gatewayAddress;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("ipCidrRange")) {
            return this.ipCidrRange;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("privateIpGoogleAccess")) {
            return this.privateIpGoogleAccess;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("secondaryIpRanges")) {
            return this.secondaryIpRanges;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getEnableFlowLogs() {
        return this.enableFlowLogs;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String getId() {
        return this.id;
    }

    public String getIpCidrRange() {
        return this.ipCidrRange;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public Boolean getPrivateIpGoogleAccess() {
        return this.privateIpGoogleAccess;
    }

    public String getRegion() {
        return this.region;
    }

    public List<SubnetworkSecondaryRange> getSecondaryIpRangesList() {
        return this.secondaryIpRanges;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Subnetwork prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Subnetwork getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Subnetwork{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", enableFlowLogs=" + this.enableFlowLogs + ", fingerprint=" + this.fingerprint + ", gatewayAddress=" + this.gatewayAddress + ", id=" + this.id + ", ipCidrRange=" + this.ipCidrRange + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", privateIpGoogleAccess=" + this.privateIpGoogleAccess + ", region=" + this.region + ", secondaryIpRanges=" + this.secondaryIpRanges + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Subnetwork) {
            Subnetwork that = (Subnetwork)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.enableFlowLogs, that.getEnableFlowLogs()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.gatewayAddress, that.getGatewayAddress()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.ipCidrRange, that.getIpCidrRange()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.privateIpGoogleAccess, that.getPrivateIpGoogleAccess()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.secondaryIpRanges, that.getSecondaryIpRangesList()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.enableFlowLogs, this.fingerprint, this.gatewayAddress, this.id, this.ipCidrRange, this.kind, this.name, this.network, this.privateIpGoogleAccess, this.region, this.secondaryIpRanges, this.selfLink);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private Boolean enableFlowLogs;
        private String fingerprint;
        private String gatewayAddress;
        private String id;
        private String ipCidrRange;
        private String kind;
        private String name;
        private String network;
        private Boolean privateIpGoogleAccess;
        private String region;
        private List<SubnetworkSecondaryRange> secondaryIpRanges;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(Subnetwork other) {
            if (other == Subnetwork.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getEnableFlowLogs() != null) {
                this.enableFlowLogs = other.enableFlowLogs;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getGatewayAddress() != null) {
                this.gatewayAddress = other.gatewayAddress;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getIpCidrRange() != null) {
                this.ipCidrRange = other.ipCidrRange;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getPrivateIpGoogleAccess() != null) {
                this.privateIpGoogleAccess = other.privateIpGoogleAccess;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSecondaryIpRangesList() != null) {
                this.secondaryIpRanges = other.secondaryIpRanges;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(Subnetwork source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.enableFlowLogs = source.enableFlowLogs;
            this.fingerprint = source.fingerprint;
            this.gatewayAddress = source.gatewayAddress;
            this.id = source.id;
            this.ipCidrRange = source.ipCidrRange;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.privateIpGoogleAccess = source.privateIpGoogleAccess;
            this.region = source.region;
            this.secondaryIpRanges = source.secondaryIpRanges;
            this.selfLink = source.selfLink;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Boolean getEnableFlowLogs() {
            return this.enableFlowLogs;
        }

        public Builder setEnableFlowLogs(Boolean enableFlowLogs) {
            this.enableFlowLogs = enableFlowLogs;
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getGatewayAddress() {
            return this.gatewayAddress;
        }

        public Builder setGatewayAddress(String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getIpCidrRange() {
            return this.ipCidrRange;
        }

        public Builder setIpCidrRange(String ipCidrRange) {
            this.ipCidrRange = ipCidrRange;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public Boolean getPrivateIpGoogleAccess() {
            return this.privateIpGoogleAccess;
        }

        public Builder setPrivateIpGoogleAccess(Boolean privateIpGoogleAccess) {
            this.privateIpGoogleAccess = privateIpGoogleAccess;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public List<SubnetworkSecondaryRange> getSecondaryIpRangesList() {
            return this.secondaryIpRanges;
        }

        public Builder addAllSecondaryIpRanges(List<SubnetworkSecondaryRange> secondaryIpRanges) {
            if (this.secondaryIpRanges == null) {
                this.secondaryIpRanges = new LinkedList<SubnetworkSecondaryRange>();
            }
            this.secondaryIpRanges.addAll(secondaryIpRanges);
            return this;
        }

        public Builder addSecondaryIpRanges(SubnetworkSecondaryRange secondaryIpRanges) {
            if (this.secondaryIpRanges == null) {
                this.secondaryIpRanges = new LinkedList<SubnetworkSecondaryRange>();
            }
            this.secondaryIpRanges.add(secondaryIpRanges);
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Subnetwork build() {
            return new Subnetwork(this.creationTimestamp, this.description, this.enableFlowLogs, this.fingerprint, this.gatewayAddress, this.id, this.ipCidrRange, this.kind, this.name, this.network, this.privateIpGoogleAccess, this.region, this.secondaryIpRanges, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setEnableFlowLogs(this.enableFlowLogs);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setGatewayAddress(this.gatewayAddress);
            newBuilder.setId(this.id);
            newBuilder.setIpCidrRange(this.ipCidrRange);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setPrivateIpGoogleAccess(this.privateIpGoogleAccess);
            newBuilder.setRegion(this.region);
            newBuilder.addAllSecondaryIpRanges(this.secondaryIpRanges);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

