/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.RouterAdvertisedIpRange;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterBgpPeer
implements ApiMessage {
    private final String advertiseMode;
    private final List<String> advertisedGroups;
    private final List<RouterAdvertisedIpRange> advertisedIpRanges;
    private final Integer advertisedRoutePriority;
    private final String interfaceName;
    private final String ipAddress;
    private final String managementType;
    private final String name;
    private final Integer peerAsn;
    private final String peerIpAddress;
    private static final RouterBgpPeer DEFAULT_INSTANCE = new RouterBgpPeer();

    private RouterBgpPeer() {
        this.advertiseMode = null;
        this.advertisedGroups = null;
        this.advertisedIpRanges = null;
        this.advertisedRoutePriority = null;
        this.interfaceName = null;
        this.ipAddress = null;
        this.managementType = null;
        this.name = null;
        this.peerAsn = null;
        this.peerIpAddress = null;
    }

    private RouterBgpPeer(String advertiseMode, List<String> advertisedGroups, List<RouterAdvertisedIpRange> advertisedIpRanges, Integer advertisedRoutePriority, String interfaceName, String ipAddress, String managementType, String name, Integer peerAsn, String peerIpAddress) {
        this.advertiseMode = advertiseMode;
        this.advertisedGroups = advertisedGroups;
        this.advertisedIpRanges = advertisedIpRanges;
        this.advertisedRoutePriority = advertisedRoutePriority;
        this.interfaceName = interfaceName;
        this.ipAddress = ipAddress;
        this.managementType = managementType;
        this.name = name;
        this.peerAsn = peerAsn;
        this.peerIpAddress = peerIpAddress;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("advertiseMode")) {
            return this.advertiseMode;
        }
        if (fieldName.equals("advertisedGroups")) {
            return this.advertisedGroups;
        }
        if (fieldName.equals("advertisedIpRanges")) {
            return this.advertisedIpRanges;
        }
        if (fieldName.equals("advertisedRoutePriority")) {
            return this.advertisedRoutePriority;
        }
        if (fieldName.equals("interfaceName")) {
            return this.interfaceName;
        }
        if (fieldName.equals("ipAddress")) {
            return this.ipAddress;
        }
        if (fieldName.equals("managementType")) {
            return this.managementType;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("peerAsn")) {
            return this.peerAsn;
        }
        if (fieldName.equals("peerIpAddress")) {
            return this.peerIpAddress;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAdvertiseMode() {
        return this.advertiseMode;
    }

    public List<String> getAdvertisedGroupsList() {
        return this.advertisedGroups;
    }

    public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
        return this.advertisedIpRanges;
    }

    public Integer getAdvertisedRoutePriority() {
        return this.advertisedRoutePriority;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getManagementType() {
        return this.managementType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPeerAsn() {
        return this.peerAsn;
    }

    public String getPeerIpAddress() {
        return this.peerIpAddress;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterBgpPeer prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterBgpPeer getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterBgpPeer{advertiseMode=" + this.advertiseMode + ", advertisedGroups=" + this.advertisedGroups + ", advertisedIpRanges=" + this.advertisedIpRanges + ", advertisedRoutePriority=" + this.advertisedRoutePriority + ", interfaceName=" + this.interfaceName + ", ipAddress=" + this.ipAddress + ", managementType=" + this.managementType + ", name=" + this.name + ", peerAsn=" + this.peerAsn + ", peerIpAddress=" + this.peerIpAddress + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterBgpPeer) {
            RouterBgpPeer that = (RouterBgpPeer)o;
            return Objects.equals(this.advertiseMode, that.getAdvertiseMode()) && Objects.equals(this.advertisedGroups, that.getAdvertisedGroupsList()) && Objects.equals(this.advertisedIpRanges, that.getAdvertisedIpRangesList()) && Objects.equals(this.advertisedRoutePriority, that.getAdvertisedRoutePriority()) && Objects.equals(this.interfaceName, that.getInterfaceName()) && Objects.equals(this.ipAddress, that.getIpAddress()) && Objects.equals(this.managementType, that.getManagementType()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.peerAsn, that.getPeerAsn()) && Objects.equals(this.peerIpAddress, that.getPeerIpAddress());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.advertiseMode, this.advertisedGroups, this.advertisedIpRanges, this.advertisedRoutePriority, this.interfaceName, this.ipAddress, this.managementType, this.name, this.peerAsn, this.peerIpAddress);
    }

    public static class Builder {
        private String advertiseMode;
        private List<String> advertisedGroups;
        private List<RouterAdvertisedIpRange> advertisedIpRanges;
        private Integer advertisedRoutePriority;
        private String interfaceName;
        private String ipAddress;
        private String managementType;
        private String name;
        private Integer peerAsn;
        private String peerIpAddress;

        Builder() {
        }

        public Builder mergeFrom(RouterBgpPeer other) {
            if (other == RouterBgpPeer.getDefaultInstance()) {
                return this;
            }
            if (other.getAdvertiseMode() != null) {
                this.advertiseMode = other.advertiseMode;
            }
            if (other.getAdvertisedGroupsList() != null) {
                this.advertisedGroups = other.advertisedGroups;
            }
            if (other.getAdvertisedIpRangesList() != null) {
                this.advertisedIpRanges = other.advertisedIpRanges;
            }
            if (other.getAdvertisedRoutePriority() != null) {
                this.advertisedRoutePriority = other.advertisedRoutePriority;
            }
            if (other.getInterfaceName() != null) {
                this.interfaceName = other.interfaceName;
            }
            if (other.getIpAddress() != null) {
                this.ipAddress = other.ipAddress;
            }
            if (other.getManagementType() != null) {
                this.managementType = other.managementType;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPeerAsn() != null) {
                this.peerAsn = other.peerAsn;
            }
            if (other.getPeerIpAddress() != null) {
                this.peerIpAddress = other.peerIpAddress;
            }
            return this;
        }

        Builder(RouterBgpPeer source) {
            this.advertiseMode = source.advertiseMode;
            this.advertisedGroups = source.advertisedGroups;
            this.advertisedIpRanges = source.advertisedIpRanges;
            this.advertisedRoutePriority = source.advertisedRoutePriority;
            this.interfaceName = source.interfaceName;
            this.ipAddress = source.ipAddress;
            this.managementType = source.managementType;
            this.name = source.name;
            this.peerAsn = source.peerAsn;
            this.peerIpAddress = source.peerIpAddress;
        }

        public String getAdvertiseMode() {
            return this.advertiseMode;
        }

        public Builder setAdvertiseMode(String advertiseMode) {
            this.advertiseMode = advertiseMode;
            return this;
        }

        public List<String> getAdvertisedGroupsList() {
            return this.advertisedGroups;
        }

        public Builder addAllAdvertisedGroups(List<String> advertisedGroups) {
            if (this.advertisedGroups == null) {
                this.advertisedGroups = new LinkedList<String>();
            }
            this.advertisedGroups.addAll(advertisedGroups);
            return this;
        }

        public Builder addAdvertisedGroups(String advertisedGroups) {
            if (this.advertisedGroups == null) {
                this.advertisedGroups = new LinkedList<String>();
            }
            this.advertisedGroups.add(advertisedGroups);
            return this;
        }

        public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
            return this.advertisedIpRanges;
        }

        public Builder addAllAdvertisedIpRanges(List<RouterAdvertisedIpRange> advertisedIpRanges) {
            if (this.advertisedIpRanges == null) {
                this.advertisedIpRanges = new LinkedList<RouterAdvertisedIpRange>();
            }
            this.advertisedIpRanges.addAll(advertisedIpRanges);
            return this;
        }

        public Builder addAdvertisedIpRanges(RouterAdvertisedIpRange advertisedIpRanges) {
            if (this.advertisedIpRanges == null) {
                this.advertisedIpRanges = new LinkedList<RouterAdvertisedIpRange>();
            }
            this.advertisedIpRanges.add(advertisedIpRanges);
            return this;
        }

        public Integer getAdvertisedRoutePriority() {
            return this.advertisedRoutePriority;
        }

        public Builder setAdvertisedRoutePriority(Integer advertisedRoutePriority) {
            this.advertisedRoutePriority = advertisedRoutePriority;
            return this;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public Builder setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public String getManagementType() {
            return this.managementType;
        }

        public Builder setManagementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Integer getPeerAsn() {
            return this.peerAsn;
        }

        public Builder setPeerAsn(Integer peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public String getPeerIpAddress() {
            return this.peerIpAddress;
        }

        public Builder setPeerIpAddress(String peerIpAddress) {
            this.peerIpAddress = peerIpAddress;
            return this;
        }

        public RouterBgpPeer build() {
            return new RouterBgpPeer(this.advertiseMode, this.advertisedGroups, this.advertisedIpRanges, this.advertisedRoutePriority, this.interfaceName, this.ipAddress, this.managementType, this.name, this.peerAsn, this.peerIpAddress);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAdvertiseMode(this.advertiseMode);
            newBuilder.addAllAdvertisedGroups(this.advertisedGroups);
            newBuilder.addAllAdvertisedIpRanges(this.advertisedIpRanges);
            newBuilder.setAdvertisedRoutePriority(this.advertisedRoutePriority);
            newBuilder.setInterfaceName(this.interfaceName);
            newBuilder.setIpAddress(this.ipAddress);
            newBuilder.setManagementType(this.managementType);
            newBuilder.setName(this.name);
            newBuilder.setPeerAsn(this.peerAsn);
            newBuilder.setPeerIpAddress(this.peerIpAddress);
            return newBuilder;
        }
    }
}

