/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Subnetwork;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SubnetworkInfo
implements Serializable {
    static final Function<Subnetwork, SubnetworkInfo> FROM_PB_FUNCTION = new Function<Subnetwork, SubnetworkInfo>(){

        public SubnetworkInfo apply(Subnetwork pb) {
            return SubnetworkInfo.fromPb(pb);
        }
    };
    static final Function<SubnetworkInfo, Subnetwork> TO_PB_FUNCTION = new Function<SubnetworkInfo, Subnetwork>(){

        public Subnetwork apply(SubnetworkInfo subnetwork) {
            return subnetwork.toPb();
        }
    };
    private static final long serialVersionUID = 7491176262675441579L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final SubnetworkId subnetworkId;
    private final Long creationTimestamp;
    private final String description;
    private final String gatewayAddress;
    private final NetworkId network;
    private final String ipRange;

    SubnetworkInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.subnetworkId = (SubnetworkId)Preconditions.checkNotNull((Object)builder.subnetworkId);
        this.description = builder.description;
        this.gatewayAddress = builder.gatewayAddress;
        this.network = builder.network;
        this.ipRange = builder.ipRange;
    }

    @Deprecated
    public String generatedId() {
        return this.getGeneratedId();
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    @Deprecated
    public Long creationTimestamp() {
        return this.getCreationTimestamp();
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Deprecated
    public SubnetworkId subnetworkId() {
        return this.getSubnetworkId();
    }

    public SubnetworkId getSubnetworkId() {
        return this.subnetworkId;
    }

    @Deprecated
    public String description() {
        return this.getDescription();
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String gatewayAddress() {
        return this.getGatewayAddress();
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    @Deprecated
    public NetworkId network() {
        return this.getNetwork();
    }

    public NetworkId getNetwork() {
        return this.network;
    }

    @Deprecated
    public String ipRange() {
        return this.ipRange;
    }

    public String getIpRange() {
        return this.ipRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("subnetworkId", (Object)this.subnetworkId).add("description", (Object)this.description).add("gatewayAddress", (Object)this.gatewayAddress).add("network", (Object)this.network).add("ipRange", (Object)this.ipRange).toString();
    }

    public int hashCode() {
        return Objects.hash(this.generatedId, this.creationTimestamp, this.subnetworkId, this.description, this.gatewayAddress, this.network, this.ipRange);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SubnetworkInfo.class) && Objects.equals(this.toPb(), ((SubnetworkInfo)obj).toPb());
    }

    SubnetworkInfo setProjectId(String projectId) {
        return this.toBuilder().setSubnetworkId(this.subnetworkId.setProjectId(projectId)).setNetwork(this.network.setProjectId(projectId)).build();
    }

    Subnetwork toPb() {
        Subnetwork subnetworkPb = new Subnetwork();
        if (this.generatedId != null) {
            subnetworkPb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            subnetworkPb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        subnetworkPb.setName(this.subnetworkId.getSubnetwork());
        subnetworkPb.setDescription(this.description);
        subnetworkPb.setSelfLink(this.subnetworkId.getSelfLink());
        subnetworkPb.setGatewayAddress(this.gatewayAddress);
        subnetworkPb.setNetwork(this.network.getSelfLink());
        subnetworkPb.setIpCidrRange(this.ipRange);
        return subnetworkPb;
    }

    @Deprecated
    public static Builder builder(SubnetworkId subnetworkId, NetworkId network, String ipRange) {
        return SubnetworkInfo.newBuilder(subnetworkId, network, ipRange);
    }

    public static Builder newBuilder(SubnetworkId subnetworkId, NetworkId network, String ipRange) {
        return new BuilderImpl(subnetworkId, network, ipRange);
    }

    public static SubnetworkInfo of(SubnetworkId subnetworkId, NetworkId network, String ipRange) {
        return SubnetworkInfo.newBuilder(subnetworkId, network, ipRange).build();
    }

    static SubnetworkInfo fromPb(Subnetwork subnetworkPb) {
        return new BuilderImpl(subnetworkPb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private SubnetworkId subnetworkId;
        private Long creationTimestamp;
        private String description;
        private String gatewayAddress;
        private NetworkId network;
        private String ipRange;

        BuilderImpl(SubnetworkId subnetworkId, NetworkId network, String ipRange) {
            this.subnetworkId = (SubnetworkId)Preconditions.checkNotNull((Object)subnetworkId);
            this.network = (NetworkId)Preconditions.checkNotNull((Object)network);
            this.ipRange = (String)Preconditions.checkNotNull((Object)ipRange);
        }

        BuilderImpl(SubnetworkInfo subnetworkInfo) {
            this.generatedId = subnetworkInfo.generatedId;
            this.creationTimestamp = subnetworkInfo.creationTimestamp;
            this.subnetworkId = subnetworkInfo.subnetworkId;
            this.description = subnetworkInfo.description;
            this.gatewayAddress = subnetworkInfo.gatewayAddress;
            this.network = subnetworkInfo.network;
            this.ipRange = subnetworkInfo.ipRange;
        }

        BuilderImpl(Subnetwork subnetworkPb) {
            if (subnetworkPb.getId() != null) {
                this.generatedId = subnetworkPb.getId().toString();
            }
            if (subnetworkPb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(subnetworkPb.getCreationTimestamp());
            }
            this.subnetworkId = SubnetworkId.fromUrl(subnetworkPb.getSelfLink());
            this.description = subnetworkPb.getDescription();
            this.gatewayAddress = subnetworkPb.getGatewayAddress();
            if (subnetworkPb.getNetwork() != null) {
                this.network = NetworkId.fromUrl(subnetworkPb.getNetwork());
            }
            this.ipRange = subnetworkPb.getIpCidrRange();
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        BuilderImpl setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        @Deprecated
        public BuilderImpl subnetworkId(SubnetworkId subnetworkId) {
            return this.setSubnetworkId(subnetworkId);
        }

        @Override
        public BuilderImpl setSubnetworkId(SubnetworkId subnetworkId) {
            this.subnetworkId = (SubnetworkId)Preconditions.checkNotNull((Object)subnetworkId);
            return this;
        }

        @Override
        @Deprecated
        public BuilderImpl description(String description) {
            return this.setDescription(description);
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        BuilderImpl setGatewayAddress(String gatewayAddress) {
            this.gatewayAddress = gatewayAddress;
            return this;
        }

        @Override
        @Deprecated
        public BuilderImpl network(NetworkId network) {
            return this.setNetwork(network);
        }

        @Override
        public BuilderImpl setNetwork(NetworkId network) {
            this.network = (NetworkId)Preconditions.checkNotNull((Object)network);
            return this;
        }

        @Override
        @Deprecated
        public BuilderImpl ipRange(String ipRange) {
            return this.setIpRange(ipRange);
        }

        @Override
        public BuilderImpl setIpRange(String ipRange) {
            this.ipRange = (String)Preconditions.checkNotNull((Object)ipRange);
            return this;
        }

        @Override
        public SubnetworkInfo build() {
            return new SubnetworkInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setGeneratedId(String var1);

        abstract Builder setCreationTimestamp(Long var1);

        @Deprecated
        public abstract Builder subnetworkId(SubnetworkId var1);

        public abstract Builder setSubnetworkId(SubnetworkId var1);

        @Deprecated
        public abstract Builder description(String var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setGatewayAddress(String var1);

        @Deprecated
        public abstract Builder network(NetworkId var1);

        public abstract Builder setNetwork(NetworkId var1);

        @Deprecated
        public abstract Builder ipRange(String var1);

        public abstract Builder setIpRange(String var1);

        public abstract SubnetworkInfo build();
    }
}

