/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.MachineType;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class MachineTypesScopedList
implements ApiMessage {
    private final List<MachineType> machineTypes;
    private final Warning warning;
    private static final MachineTypesScopedList DEFAULT_INSTANCE = new MachineTypesScopedList();

    private MachineTypesScopedList() {
        this.machineTypes = null;
        this.warning = null;
    }

    private MachineTypesScopedList(List<MachineType> machineTypes, Warning warning) {
        this.machineTypes = machineTypes;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("machineTypes")) {
            return this.machineTypes;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<MachineType> getMachineTypesList() {
        return this.machineTypes;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MachineTypesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static MachineTypesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "MachineTypesScopedList{machineTypes=" + this.machineTypes + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MachineTypesScopedList) {
            MachineTypesScopedList that = (MachineTypesScopedList)o;
            return Objects.equals(this.machineTypes, that.getMachineTypesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.machineTypes, this.warning);
    }

    public static class Builder {
        private List<MachineType> machineTypes;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(MachineTypesScopedList other) {
            if (other == MachineTypesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getMachineTypesList() != null) {
                this.machineTypes = other.machineTypes;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(MachineTypesScopedList source) {
            this.machineTypes = source.machineTypes;
            this.warning = source.warning;
        }

        public List<MachineType> getMachineTypesList() {
            return this.machineTypes;
        }

        public Builder addAllMachineTypes(List<MachineType> machineTypes) {
            if (this.machineTypes == null) {
                this.machineTypes = new LinkedList<MachineType>();
            }
            this.machineTypes.addAll(machineTypes);
            return this;
        }

        public Builder addMachineTypes(MachineType machineTypes) {
            if (this.machineTypes == null) {
                this.machineTypes = new LinkedList<MachineType>();
            }
            this.machineTypes.add(machineTypes);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public MachineTypesScopedList build() {
            return new MachineTypesScopedList(this.machineTypes, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllMachineTypes(this.machineTypes);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

