/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.deprecated.DeprecationStatus;
import com.google.cloud.compute.deprecated.ImageConfiguration;
import com.google.cloud.compute.deprecated.ImageId;
import com.google.cloud.compute.deprecated.LicenseId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ImageInfo
implements Serializable {
    static final Function<Image, ImageInfo> FROM_PB_FUNCTION = new Function<Image, ImageInfo>(){

        public ImageInfo apply(Image pb) {
            return ImageInfo.fromPb(pb);
        }
    };
    static final Function<ImageInfo, Image> TO_PB_FUNCTION = new Function<ImageInfo, Image>(){

        public Image apply(ImageInfo image) {
            return image.toPb();
        }
    };
    private static final long serialVersionUID = -1061916352807358977L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final ImageId imageId;
    private final Long creationTimestamp;
    private final String description;
    private final ImageConfiguration configuration;
    private final Status status;
    private final Long diskSizeGb;
    private final List<LicenseId> licenses;
    private final DeprecationStatus<ImageId> deprecationStatus;

    ImageInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.imageId = (ImageId)Preconditions.checkNotNull((Object)builder.imageId);
        this.description = builder.description;
        this.configuration = (ImageConfiguration)Preconditions.checkNotNull((Object)builder.configuration);
        this.status = builder.status;
        this.diskSizeGb = builder.diskSizeGb;
        this.licenses = builder.licenses;
        this.deprecationStatus = builder.deprecationStatus;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public ImageId getImageId() {
        return this.imageId;
    }

    public String getDescription() {
        return this.description;
    }

    public <T extends ImageConfiguration> T getConfiguration() {
        return (T)this.configuration;
    }

    public List<LicenseId> getLicenses() {
        return this.licenses;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public DeprecationStatus<ImageId> getDeprecationStatus() {
        return this.deprecationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("imageId", (Object)this.imageId).add("description", (Object)this.description).add("configuration", (Object)this.configuration).add("status", (Object)this.status).add("diskSizeGb", (Object)this.diskSizeGb).add("licenses", this.licenses).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.generatedId, this.creationTimestamp, this.imageId, this.description, this.configuration, this.status, this.diskSizeGb, this.licenses});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ImageInfo.class) && Objects.equals(this.toPb(), ((ImageInfo)obj).toPb());
    }

    ImageInfo setProjectId(String projectId) {
        return this.toBuilder().setImageId(this.imageId.setProjectId(projectId)).setConfiguration(this.configuration.setProjectId(projectId)).build();
    }

    Image toPb() {
        Image imagePb = this.configuration.toPb();
        if (this.generatedId != null) {
            imagePb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            imagePb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        imagePb.setName(this.imageId.getImage());
        imagePb.setDescription(this.description);
        imagePb.setSelfLink(this.imageId.getSelfLink());
        if (this.status != null) {
            imagePb.setStatus(this.status.name());
        }
        imagePb.setDiskSizeGb(this.diskSizeGb);
        if (this.licenses != null) {
            imagePb.setLicenses(Lists.transform(this.licenses, LicenseId.TO_URL_FUNCTION));
        }
        if (this.deprecationStatus != null) {
            imagePb.setDeprecated(this.deprecationStatus.toPb());
        }
        return imagePb;
    }

    public static Builder newBuilder(ImageId imageId, ImageConfiguration configuration) {
        return new BuilderImpl().setImageId(imageId).setConfiguration(configuration);
    }

    public static ImageInfo of(ImageId imageId, ImageConfiguration configuration) {
        return ImageInfo.newBuilder(imageId, configuration).build();
    }

    static ImageInfo fromPb(Image imagePb) {
        return new BuilderImpl(imagePb).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private Long creationTimestamp;
        private ImageId imageId;
        private String description;
        private ImageConfiguration configuration;
        private Status status;
        private Long diskSizeGb;
        private List<LicenseId> licenses;
        private DeprecationStatus<ImageId> deprecationStatus;

        BuilderImpl() {
        }

        BuilderImpl(ImageInfo imageInfo) {
            this.generatedId = imageInfo.generatedId;
            this.creationTimestamp = imageInfo.creationTimestamp;
            this.imageId = imageInfo.imageId;
            this.description = imageInfo.description;
            this.configuration = imageInfo.configuration;
            this.status = imageInfo.status;
            this.diskSizeGb = imageInfo.diskSizeGb;
            this.licenses = imageInfo.licenses;
            this.deprecationStatus = imageInfo.deprecationStatus;
        }

        BuilderImpl(Image imagePb) {
            if (imagePb.getId() != null) {
                this.generatedId = imagePb.getId().toString();
            }
            if (imagePb.getCreationTimestamp() != null) {
                this.creationTimestamp = TIMESTAMP_FORMATTER.parseMillis(imagePb.getCreationTimestamp());
            }
            this.imageId = ImageId.fromUrl(imagePb.getSelfLink());
            this.description = imagePb.getDescription();
            this.configuration = ImageConfiguration.fromPb(imagePb);
            if (imagePb.getStatus() != null) {
                this.status = Status.valueOf(imagePb.getStatus());
            }
            this.diskSizeGb = imagePb.getDiskSizeGb();
            if (imagePb.getLicenses() != null) {
                this.licenses = Lists.transform((List)imagePb.getLicenses(), LicenseId.FROM_URL_FUNCTION);
            }
            if (imagePb.getDeprecated() != null) {
                this.deprecationStatus = DeprecationStatus.fromPb(imagePb.getDeprecated(), ImageId.FROM_URL_FUNCTION);
            }
        }

        @Override
        BuilderImpl setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        BuilderImpl getCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public BuilderImpl setImageId(ImageId imageId) {
            this.imageId = (ImageId)Preconditions.checkNotNull((Object)imageId);
            return this;
        }

        @Override
        public BuilderImpl setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BuilderImpl setConfiguration(ImageConfiguration configuration) {
            this.configuration = (ImageConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        BuilderImpl setStatus(Status status) {
            this.status = status;
            return this;
        }

        @Override
        BuilderImpl setDiskSizeGb(Long diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        @Override
        BuilderImpl setLicenses(List<LicenseId> licenses) {
            this.licenses = licenses != null ? ImmutableList.copyOf(licenses) : null;
            return this;
        }

        @Override
        BuilderImpl setDeprecationStatus(DeprecationStatus<ImageId> deprecationStatus) {
            this.deprecationStatus = deprecationStatus;
            return this;
        }

        @Override
        public ImageInfo build() {
            return new ImageInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setGeneratedId(String var1);

        abstract Builder getCreationTimestamp(Long var1);

        public abstract Builder setImageId(ImageId var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setConfiguration(ImageConfiguration var1);

        abstract Builder setStatus(Status var1);

        abstract Builder setDiskSizeGb(Long var1);

        abstract Builder setLicenses(List<LicenseId> var1);

        abstract Builder setDeprecationStatus(DeprecationStatus<ImageId> var1);

        public abstract ImageInfo build();
    }

    public static enum Status {
        FAILED,
        PENDING,
        READY;

    }
}

