/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInterconnectLocationHttpRequest;
import com.google.cloud.compute.v1.InterconnectLocation;
import com.google.cloud.compute.v1.InterconnectLocationClient;
import com.google.cloud.compute.v1.InterconnectLocationList;
import com.google.cloud.compute.v1.ListInterconnectLocationsHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectLocationStub;
import com.google.cloud.compute.v1.stub.InterconnectLocationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InterconnectLocationStubSettings
extends StubSettings<InterconnectLocationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<GetInterconnectLocationHttpRequest, InterconnectLocation> getInterconnectLocationSettings;
    private final PagedCallSettings<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse> listInterconnectLocationsSettings;
    private static final PagedListDescriptor<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation> LIST_INTERCONNECT_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectLocationsHttpRequest injectToken(ListInterconnectLocationsHttpRequest payload, String token) {
            return ListInterconnectLocationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInterconnectLocationsHttpRequest injectPageSize(ListInterconnectLocationsHttpRequest payload, int pageSize) {
            return ListInterconnectLocationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectLocationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectLocationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectLocation> extractResources(InterconnectLocationList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse> LIST_INTERCONNECT_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse>(){

        public ApiFuture<InterconnectLocationClient.ListInterconnectLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectLocationsHttpRequest, InterconnectLocationList> callable, ListInterconnectLocationsHttpRequest request, ApiCallContext context, ApiFuture<InterconnectLocationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERCONNECT_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectLocationClient.ListInterconnectLocationsPagedResponse.createAsync((PageContext<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetInterconnectLocationHttpRequest, InterconnectLocation> getInterconnectLocationSettings() {
        return this.getInterconnectLocationSettings;
    }

    public PagedCallSettings<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse> listInterconnectLocationsSettings() {
        return this.listInterconnectLocationsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectLocationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectLocationStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectLocationStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectLocationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectLocationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getInterconnectLocationSettings = settingsBuilder.getInterconnectLocationSettings().build();
        this.listInterconnectLocationsSettings = settingsBuilder.listInterconnectLocationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectLocationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetInterconnectLocationHttpRequest, InterconnectLocation> getInterconnectLocationSettings;
        private final PagedCallSettings.Builder<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse> listInterconnectLocationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getInterconnectLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInterconnectLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERCONNECT_LOCATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getInterconnectLocationSettings, this.listInterconnectLocationsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectLocationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectLocationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectLocationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InterconnectLocationStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getInterconnectLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInterconnectLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InterconnectLocationStubSettings settings) {
            super((StubSettings)settings);
            this.getInterconnectLocationSettings = settings.getInterconnectLocationSettings.toBuilder();
            this.listInterconnectLocationsSettings = settings.listInterconnectLocationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getInterconnectLocationSettings, this.listInterconnectLocationsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetInterconnectLocationHttpRequest, InterconnectLocation> getInterconnectLocationSettings() {
            return this.getInterconnectLocationSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectLocationsHttpRequest, InterconnectLocationList, InterconnectLocationClient.ListInterconnectLocationsPagedResponse> listInterconnectLocationsSettings() {
            return this.listInterconnectLocationsSettings;
        }

        public InterconnectLocationStubSettings build() throws IOException {
            return new InterconnectLocationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

