/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ForwardingRule
implements ApiMessage {
    private final String backendService;
    private final String creationTimestamp;
    private final String description;
    private final String iPAddress;
    private final String iPProtocol;
    private final String id;
    private final String ipVersion;
    private final String kind;
    private final String loadBalancingScheme;
    private final String name;
    private final String network;
    private final String portRange;
    private final List<String> ports;
    private final String region;
    private final String selfLink;
    private final String subnetwork;
    private final String target;
    private static final ForwardingRule DEFAULT_INSTANCE = new ForwardingRule();

    private ForwardingRule() {
        this.backendService = null;
        this.creationTimestamp = null;
        this.description = null;
        this.iPAddress = null;
        this.iPProtocol = null;
        this.id = null;
        this.ipVersion = null;
        this.kind = null;
        this.loadBalancingScheme = null;
        this.name = null;
        this.network = null;
        this.portRange = null;
        this.ports = null;
        this.region = null;
        this.selfLink = null;
        this.subnetwork = null;
        this.target = null;
    }

    private ForwardingRule(String backendService, String creationTimestamp, String description, String iPAddress, String iPProtocol, String id, String ipVersion, String kind, String loadBalancingScheme, String name, String network, String portRange, List<String> ports, String region, String selfLink, String subnetwork, String target) {
        this.backendService = backendService;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.iPAddress = iPAddress;
        this.iPProtocol = iPProtocol;
        this.id = id;
        this.ipVersion = ipVersion;
        this.kind = kind;
        this.loadBalancingScheme = loadBalancingScheme;
        this.name = name;
        this.network = network;
        this.portRange = portRange;
        this.ports = ports;
        this.region = region;
        this.selfLink = selfLink;
        this.subnetwork = subnetwork;
        this.target = target;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("backendService")) {
            return this.backendService;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("iPAddress")) {
            return this.iPAddress;
        }
        if (fieldName.equals("iPProtocol")) {
            return this.iPProtocol;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("ipVersion")) {
            return this.ipVersion;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("loadBalancingScheme")) {
            return this.loadBalancingScheme;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("portRange")) {
            return this.portRange;
        }
        if (fieldName.equals("ports")) {
            return this.ports;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("subnetwork")) {
            return this.subnetwork;
        }
        if (fieldName.equals("target")) {
            return this.target;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getBackendService() {
        return this.backendService;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIPAddress() {
        return this.iPAddress;
    }

    public String getIPProtocol() {
        return this.iPProtocol;
    }

    public String getId() {
        return this.id;
    }

    public String getIpVersion() {
        return this.ipVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLoadBalancingScheme() {
        return this.loadBalancingScheme;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getPortRange() {
        return this.portRange;
    }

    public List<String> getPortsList() {
        return this.ports;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public String getTarget() {
        return this.target;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ForwardingRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ForwardingRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ForwardingRule{backendService=" + this.backendService + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", iPAddress=" + this.iPAddress + ", iPProtocol=" + this.iPProtocol + ", id=" + this.id + ", ipVersion=" + this.ipVersion + ", kind=" + this.kind + ", loadBalancingScheme=" + this.loadBalancingScheme + ", name=" + this.name + ", network=" + this.network + ", portRange=" + this.portRange + ", ports=" + this.ports + ", region=" + this.region + ", selfLink=" + this.selfLink + ", subnetwork=" + this.subnetwork + ", target=" + this.target + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ForwardingRule) {
            ForwardingRule that = (ForwardingRule)o;
            return Objects.equals(this.backendService, that.getBackendService()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.iPAddress, that.getIPAddress()) && Objects.equals(this.iPProtocol, that.getIPProtocol()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.ipVersion, that.getIpVersion()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.loadBalancingScheme, that.getLoadBalancingScheme()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.portRange, that.getPortRange()) && Objects.equals(this.ports, that.getPortsList()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.subnetwork, that.getSubnetwork()) && Objects.equals(this.target, that.getTarget());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.backendService, this.creationTimestamp, this.description, this.iPAddress, this.iPProtocol, this.id, this.ipVersion, this.kind, this.loadBalancingScheme, this.name, this.network, this.portRange, this.ports, this.region, this.selfLink, this.subnetwork, this.target);
    }

    public static class Builder {
        private String backendService;
        private String creationTimestamp;
        private String description;
        private String iPAddress;
        private String iPProtocol;
        private String id;
        private String ipVersion;
        private String kind;
        private String loadBalancingScheme;
        private String name;
        private String network;
        private String portRange;
        private List<String> ports;
        private String region;
        private String selfLink;
        private String subnetwork;
        private String target;

        Builder() {
        }

        public Builder mergeFrom(ForwardingRule other) {
            if (other == ForwardingRule.getDefaultInstance()) {
                return this;
            }
            if (other.getBackendService() != null) {
                this.backendService = other.backendService;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getIPAddress() != null) {
                this.iPAddress = other.iPAddress;
            }
            if (other.getIPProtocol() != null) {
                this.iPProtocol = other.iPProtocol;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getIpVersion() != null) {
                this.ipVersion = other.ipVersion;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLoadBalancingScheme() != null) {
                this.loadBalancingScheme = other.loadBalancingScheme;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getPortRange() != null) {
                this.portRange = other.portRange;
            }
            if (other.getPortsList() != null) {
                this.ports = other.ports;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            if (other.getTarget() != null) {
                this.target = other.target;
            }
            return this;
        }

        Builder(ForwardingRule source) {
            this.backendService = source.backendService;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.iPAddress = source.iPAddress;
            this.iPProtocol = source.iPProtocol;
            this.id = source.id;
            this.ipVersion = source.ipVersion;
            this.kind = source.kind;
            this.loadBalancingScheme = source.loadBalancingScheme;
            this.name = source.name;
            this.network = source.network;
            this.portRange = source.portRange;
            this.ports = source.ports;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.subnetwork = source.subnetwork;
            this.target = source.target;
        }

        public String getBackendService() {
            return this.backendService;
        }

        public Builder setBackendService(String backendService) {
            this.backendService = backendService;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getIPAddress() {
            return this.iPAddress;
        }

        public Builder setIPAddress(String iPAddress) {
            this.iPAddress = iPAddress;
            return this;
        }

        public String getIPProtocol() {
            return this.iPProtocol;
        }

        public Builder setIPProtocol(String iPProtocol) {
            this.iPProtocol = iPProtocol;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public Builder setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLoadBalancingScheme() {
            return this.loadBalancingScheme;
        }

        public Builder setLoadBalancingScheme(String loadBalancingScheme) {
            this.loadBalancingScheme = loadBalancingScheme;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getPortRange() {
            return this.portRange;
        }

        public Builder setPortRange(String portRange) {
            this.portRange = portRange;
            return this;
        }

        public List<String> getPortsList() {
            return this.ports;
        }

        public Builder addAllPorts(List<String> ports) {
            if (this.ports == null) {
                this.ports = new LinkedList<String>();
            }
            this.ports.addAll(ports);
            return this;
        }

        public Builder addPorts(String ports) {
            if (this.ports == null) {
                this.ports = new LinkedList<String>();
            }
            this.ports.add(ports);
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public ForwardingRule build() {
            return new ForwardingRule(this.backendService, this.creationTimestamp, this.description, this.iPAddress, this.iPProtocol, this.id, this.ipVersion, this.kind, this.loadBalancingScheme, this.name, this.network, this.portRange, this.ports, this.region, this.selfLink, this.subnetwork, this.target);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBackendService(this.backendService);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setIPAddress(this.iPAddress);
            newBuilder.setIPProtocol(this.iPProtocol);
            newBuilder.setId(this.id);
            newBuilder.setIpVersion(this.ipVersion);
            newBuilder.setKind(this.kind);
            newBuilder.setLoadBalancingScheme(this.loadBalancingScheme);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setPortRange(this.portRange);
            newBuilder.addAllPorts(this.ports);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSubnetwork(this.subnetwork);
            newBuilder.setTarget(this.target);
            return newBuilder;
        }
    }
}

