/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.GetTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.InsertTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.ListTargetHttpsProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetSslCertificatesTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyClient;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetHttpsProxyStub;
import com.google.cloud.compute.v1.stub.TargetHttpsProxyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TargetHttpsProxyStubSettings
extends StubSettings<TargetHttpsProxyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteTargetHttpsProxyHttpRequest, Operation> deleteTargetHttpsProxySettings;
    private final UnaryCallSettings<GetTargetHttpsProxyHttpRequest, TargetHttpsProxy> getTargetHttpsProxySettings;
    private final UnaryCallSettings<InsertTargetHttpsProxyHttpRequest, Operation> insertTargetHttpsProxySettings;
    private final PagedCallSettings<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> listTargetHttpsProxiesSettings;
    private final UnaryCallSettings<SetSslCertificatesTargetHttpsProxyHttpRequest, Operation> setSslCertificatesTargetHttpsProxySettings;
    private final UnaryCallSettings<SetSslPolicyTargetHttpsProxyHttpRequest, Operation> setSslPolicyTargetHttpsProxySettings;
    private final UnaryCallSettings<SetUrlMapTargetHttpsProxyHttpRequest, Operation> setUrlMapTargetHttpsProxySettings;
    private static final PagedListDescriptor<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> LIST_TARGET_HTTPS_PROXIES_PAGE_STR_DESC = new PagedListDescriptor<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetHttpsProxiesHttpRequest injectToken(ListTargetHttpsProxiesHttpRequest payload, String token) {
            return ListTargetHttpsProxiesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListTargetHttpsProxiesHttpRequest injectPageSize(ListTargetHttpsProxiesHttpRequest payload, int pageSize) {
            return ListTargetHttpsProxiesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetHttpsProxiesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpsProxy> extractResources(TargetHttpsProxyList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> LIST_TARGET_HTTPS_PROXIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse>(){

        public ApiFuture<TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList> callable, ListTargetHttpsProxiesHttpRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGET_HTTPS_PROXIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse.createAsync((PageContext<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetHttpsProxyHttpRequest, Operation> deleteTargetHttpsProxySettings() {
        return this.deleteTargetHttpsProxySettings;
    }

    public UnaryCallSettings<GetTargetHttpsProxyHttpRequest, TargetHttpsProxy> getTargetHttpsProxySettings() {
        return this.getTargetHttpsProxySettings;
    }

    public UnaryCallSettings<InsertTargetHttpsProxyHttpRequest, Operation> insertTargetHttpsProxySettings() {
        return this.insertTargetHttpsProxySettings;
    }

    public PagedCallSettings<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> listTargetHttpsProxiesSettings() {
        return this.listTargetHttpsProxiesSettings;
    }

    public UnaryCallSettings<SetSslCertificatesTargetHttpsProxyHttpRequest, Operation> setSslCertificatesTargetHttpsProxySettings() {
        return this.setSslCertificatesTargetHttpsProxySettings;
    }

    public UnaryCallSettings<SetSslPolicyTargetHttpsProxyHttpRequest, Operation> setSslPolicyTargetHttpsProxySettings() {
        return this.setSslPolicyTargetHttpsProxySettings;
    }

    public UnaryCallSettings<SetUrlMapTargetHttpsProxyHttpRequest, Operation> setUrlMapTargetHttpsProxySettings() {
        return this.setUrlMapTargetHttpsProxySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpsProxyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetHttpsProxyStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetHttpsProxyStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetHttpsProxyStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetHttpsProxyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteTargetHttpsProxySettings = settingsBuilder.deleteTargetHttpsProxySettings().build();
        this.getTargetHttpsProxySettings = settingsBuilder.getTargetHttpsProxySettings().build();
        this.insertTargetHttpsProxySettings = settingsBuilder.insertTargetHttpsProxySettings().build();
        this.listTargetHttpsProxiesSettings = settingsBuilder.listTargetHttpsProxiesSettings().build();
        this.setSslCertificatesTargetHttpsProxySettings = settingsBuilder.setSslCertificatesTargetHttpsProxySettings().build();
        this.setSslPolicyTargetHttpsProxySettings = settingsBuilder.setSslPolicyTargetHttpsProxySettings().build();
        this.setUrlMapTargetHttpsProxySettings = settingsBuilder.setUrlMapTargetHttpsProxySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetHttpsProxyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetHttpsProxyHttpRequest, Operation> deleteTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<GetTargetHttpsProxyHttpRequest, TargetHttpsProxy> getTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<InsertTargetHttpsProxyHttpRequest, Operation> insertTargetHttpsProxySettings;
        private final PagedCallSettings.Builder<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> listTargetHttpsProxiesSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyHttpRequest, Operation> setSslCertificatesTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyHttpRequest, Operation> setSslPolicyTargetHttpsProxySettings;
        private final UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyHttpRequest, Operation> setUrlMapTargetHttpsProxySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTargetHttpsProxiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGET_HTTPS_PROXIES_PAGE_STR_FACT);
            this.setSslCertificatesTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslPolicyTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUrlMapTargetHttpsProxySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetHttpsProxySettings, this.getTargetHttpsProxySettings, this.insertTargetHttpsProxySettings, this.listTargetHttpsProxiesSettings, this.setSslCertificatesTargetHttpsProxySettings, this.setSslPolicyTargetHttpsProxySettings, this.setUrlMapTargetHttpsProxySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetHttpsProxyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetHttpsProxyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetHttpsProxyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetHttpsProxyStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTargetHttpsProxiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSslCertificatesTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSslPolicyTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setUrlMapTargetHttpsProxySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(TargetHttpsProxyStubSettings settings) {
            super((StubSettings)settings);
            this.deleteTargetHttpsProxySettings = settings.deleteTargetHttpsProxySettings.toBuilder();
            this.getTargetHttpsProxySettings = settings.getTargetHttpsProxySettings.toBuilder();
            this.insertTargetHttpsProxySettings = settings.insertTargetHttpsProxySettings.toBuilder();
            this.listTargetHttpsProxiesSettings = settings.listTargetHttpsProxiesSettings.toBuilder();
            this.setSslCertificatesTargetHttpsProxySettings = settings.setSslCertificatesTargetHttpsProxySettings.toBuilder();
            this.setSslPolicyTargetHttpsProxySettings = settings.setSslPolicyTargetHttpsProxySettings.toBuilder();
            this.setUrlMapTargetHttpsProxySettings = settings.setUrlMapTargetHttpsProxySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteTargetHttpsProxySettings, this.getTargetHttpsProxySettings, this.insertTargetHttpsProxySettings, this.listTargetHttpsProxiesSettings, this.setSslCertificatesTargetHttpsProxySettings, this.setSslPolicyTargetHttpsProxySettings, this.setUrlMapTargetHttpsProxySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetHttpsProxyHttpRequest, Operation> deleteTargetHttpsProxySettings() {
            return this.deleteTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<GetTargetHttpsProxyHttpRequest, TargetHttpsProxy> getTargetHttpsProxySettings() {
            return this.getTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<InsertTargetHttpsProxyHttpRequest, Operation> insertTargetHttpsProxySettings() {
            return this.insertTargetHttpsProxySettings;
        }

        public PagedCallSettings.Builder<ListTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxyClient.ListTargetHttpsProxiesPagedResponse> listTargetHttpsProxiesSettings() {
            return this.listTargetHttpsProxiesSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesTargetHttpsProxyHttpRequest, Operation> setSslCertificatesTargetHttpsProxySettings() {
            return this.setSslCertificatesTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<SetSslPolicyTargetHttpsProxyHttpRequest, Operation> setSslPolicyTargetHttpsProxySettings() {
            return this.setSslPolicyTargetHttpsProxySettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapTargetHttpsProxyHttpRequest, Operation> setUrlMapTargetHttpsProxySettings() {
            return this.setUrlMapTargetHttpsProxySettings;
        }

        public TargetHttpsProxyStubSettings build() throws IOException {
            return new TargetHttpsProxyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

