/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.CustomerEncryptionKeyProtectedDisk;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstancesStartWithEncryptionKeyRequest
implements ApiMessage {
    private final List<CustomerEncryptionKeyProtectedDisk> disks;
    private static final InstancesStartWithEncryptionKeyRequest DEFAULT_INSTANCE = new InstancesStartWithEncryptionKeyRequest();

    private InstancesStartWithEncryptionKeyRequest() {
        this.disks = null;
    }

    private InstancesStartWithEncryptionKeyRequest(List<CustomerEncryptionKeyProtectedDisk> disks) {
        this.disks = disks;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("disks")) {
            return this.disks;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<CustomerEncryptionKeyProtectedDisk> getDisksList() {
        return this.disks;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstancesStartWithEncryptionKeyRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstancesStartWithEncryptionKeyRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstancesStartWithEncryptionKeyRequest{disks=" + this.disks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstancesStartWithEncryptionKeyRequest) {
            InstancesStartWithEncryptionKeyRequest that = (InstancesStartWithEncryptionKeyRequest)o;
            return Objects.equals(this.disks, that.getDisksList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disks);
    }

    public static class Builder {
        private List<CustomerEncryptionKeyProtectedDisk> disks;

        Builder() {
        }

        public Builder mergeFrom(InstancesStartWithEncryptionKeyRequest other) {
            if (other == InstancesStartWithEncryptionKeyRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getDisksList() != null) {
                this.disks = other.disks;
            }
            return this;
        }

        Builder(InstancesStartWithEncryptionKeyRequest source) {
            this.disks = source.disks;
        }

        public List<CustomerEncryptionKeyProtectedDisk> getDisksList() {
            return this.disks;
        }

        public Builder addAllDisks(List<CustomerEncryptionKeyProtectedDisk> disks) {
            if (this.disks == null) {
                this.disks = new ArrayList<CustomerEncryptionKeyProtectedDisk>(disks.size());
            }
            this.disks.addAll(disks);
            return this;
        }

        public Builder addDisks(CustomerEncryptionKeyProtectedDisk disks) {
            this.disks.add(disks);
            return this;
        }

        public InstancesStartWithEncryptionKeyRequest build() {
            return new InstancesStartWithEncryptionKeyRequest(this.disks);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDisks(this.disks);
            return newBuilder;
        }
    }
}

