/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AttachedDiskInitializeParams;
import com.google.cloud.compute.v1.CustomerEncryptionKey;
import com.google.cloud.compute.v1.GuestOsFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AttachedDisk
implements ApiMessage {
    private final Boolean autoDelete;
    private final Boolean boot;
    private final String deviceName;
    private final CustomerEncryptionKey diskEncryptionKey;
    private final List<GuestOsFeature> guestOsFeatures;
    private final Integer index;
    private final AttachedDiskInitializeParams initializeParams;
    private final String interface2;
    private final String kind;
    private final List<String> licenses;
    private final String mode;
    private final String source;
    private final String type;
    private static final AttachedDisk DEFAULT_INSTANCE = new AttachedDisk();

    private AttachedDisk() {
        this.autoDelete = null;
        this.boot = null;
        this.deviceName = null;
        this.diskEncryptionKey = null;
        this.guestOsFeatures = null;
        this.index = null;
        this.initializeParams = null;
        this.interface2 = null;
        this.kind = null;
        this.licenses = null;
        this.mode = null;
        this.source = null;
        this.type = null;
    }

    private AttachedDisk(Boolean autoDelete, Boolean boot, String deviceName, CustomerEncryptionKey diskEncryptionKey, List<GuestOsFeature> guestOsFeatures, Integer index, AttachedDiskInitializeParams initializeParams, String interface2, String kind, List<String> licenses, String mode, String source, String type) {
        this.autoDelete = autoDelete;
        this.boot = boot;
        this.deviceName = deviceName;
        this.diskEncryptionKey = diskEncryptionKey;
        this.guestOsFeatures = guestOsFeatures;
        this.index = index;
        this.initializeParams = initializeParams;
        this.interface2 = interface2;
        this.kind = kind;
        this.licenses = licenses;
        this.mode = mode;
        this.source = source;
        this.type = type;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("autoDelete")) {
            return this.autoDelete;
        }
        if (fieldName.equals("boot")) {
            return this.boot;
        }
        if (fieldName.equals("deviceName")) {
            return this.deviceName;
        }
        if (fieldName.equals("diskEncryptionKey")) {
            return this.diskEncryptionKey;
        }
        if (fieldName.equals("guestOsFeatures")) {
            return this.guestOsFeatures;
        }
        if (fieldName.equals("index")) {
            return this.index;
        }
        if (fieldName.equals("initializeParams")) {
            return this.initializeParams;
        }
        if (fieldName.equals("interface2")) {
            return this.interface2;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("licenses")) {
            return this.licenses;
        }
        if (fieldName.equals("mode")) {
            return this.mode;
        }
        if (fieldName.equals("source")) {
            return this.source;
        }
        if (fieldName.equals("type")) {
            return this.type;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public Boolean getBoot() {
        return this.boot;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public CustomerEncryptionKey getDiskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    public List<GuestOsFeature> getGuestOsFeaturesList() {
        return this.guestOsFeatures;
    }

    public Integer getIndex() {
        return this.index;
    }

    public AttachedDiskInitializeParams getInitializeParams() {
        return this.initializeParams;
    }

    public String getInterface() {
        return this.interface2;
    }

    public String getKind() {
        return this.kind;
    }

    public List<String> getLicensesList() {
        return this.licenses;
    }

    public String getMode() {
        return this.mode;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AttachedDisk prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AttachedDisk getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AttachedDisk{autoDelete=" + this.autoDelete + ", boot=" + this.boot + ", deviceName=" + this.deviceName + ", diskEncryptionKey=" + this.diskEncryptionKey + ", guestOsFeatures=" + this.guestOsFeatures + ", index=" + this.index + ", initializeParams=" + this.initializeParams + ", interface2=" + this.interface2 + ", kind=" + this.kind + ", licenses=" + this.licenses + ", mode=" + this.mode + ", source=" + this.source + ", type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AttachedDisk) {
            AttachedDisk that = (AttachedDisk)o;
            return Objects.equals(this.autoDelete, that.getAutoDelete()) && Objects.equals(this.boot, that.getBoot()) && Objects.equals(this.deviceName, that.getDeviceName()) && Objects.equals(this.diskEncryptionKey, that.getDiskEncryptionKey()) && Objects.equals(this.guestOsFeatures, that.getGuestOsFeaturesList()) && Objects.equals(this.index, that.getIndex()) && Objects.equals(this.initializeParams, that.getInitializeParams()) && Objects.equals(this.interface2, that.getInterface()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.licenses, that.getLicensesList()) && Objects.equals(this.mode, that.getMode()) && Objects.equals(this.source, that.getSource()) && Objects.equals(this.type, that.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoDelete, this.boot, this.deviceName, this.diskEncryptionKey, this.guestOsFeatures, this.index, this.initializeParams, this.interface2, this.kind, this.licenses, this.mode, this.source, this.type);
    }

    public static class Builder {
        private Boolean autoDelete;
        private Boolean boot;
        private String deviceName;
        private CustomerEncryptionKey diskEncryptionKey;
        private List<GuestOsFeature> guestOsFeatures;
        private Integer index;
        private AttachedDiskInitializeParams initializeParams;
        private String interface2;
        private String kind;
        private List<String> licenses;
        private String mode;
        private String source;
        private String type;

        Builder() {
        }

        public Builder mergeFrom(AttachedDisk other) {
            if (other == AttachedDisk.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoDelete() != null) {
                this.autoDelete = other.autoDelete;
            }
            if (other.getBoot() != null) {
                this.boot = other.boot;
            }
            if (other.getDeviceName() != null) {
                this.deviceName = other.deviceName;
            }
            if (other.getDiskEncryptionKey() != null) {
                this.diskEncryptionKey = other.diskEncryptionKey;
            }
            if (other.getGuestOsFeaturesList() != null) {
                this.guestOsFeatures = other.guestOsFeatures;
            }
            if (other.getIndex() != null) {
                this.index = other.index;
            }
            if (other.getInitializeParams() != null) {
                this.initializeParams = other.initializeParams;
            }
            if (other.getInterface() != null) {
                this.interface2 = other.interface2;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLicensesList() != null) {
                this.licenses = other.licenses;
            }
            if (other.getMode() != null) {
                this.mode = other.mode;
            }
            if (other.getSource() != null) {
                this.source = other.source;
            }
            if (other.getType() != null) {
                this.type = other.type;
            }
            return this;
        }

        Builder(AttachedDisk source) {
            this.autoDelete = source.autoDelete;
            this.boot = source.boot;
            this.deviceName = source.deviceName;
            this.diskEncryptionKey = source.diskEncryptionKey;
            this.guestOsFeatures = source.guestOsFeatures;
            this.index = source.index;
            this.initializeParams = source.initializeParams;
            this.interface2 = source.interface2;
            this.kind = source.kind;
            this.licenses = source.licenses;
            this.mode = source.mode;
            this.source = source.source;
            this.type = source.type;
        }

        public Boolean getAutoDelete() {
            return this.autoDelete;
        }

        public Builder setAutoDelete(Boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public Boolean getBoot() {
            return this.boot;
        }

        public Builder setBoot(Boolean boot) {
            this.boot = boot;
            return this;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public Builder setDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public CustomerEncryptionKey getDiskEncryptionKey() {
            return this.diskEncryptionKey;
        }

        public Builder setDiskEncryptionKey(CustomerEncryptionKey diskEncryptionKey) {
            this.diskEncryptionKey = diskEncryptionKey;
            return this;
        }

        public List<GuestOsFeature> getGuestOsFeaturesList() {
            return this.guestOsFeatures;
        }

        public Builder addAllGuestOsFeatures(List<GuestOsFeature> guestOsFeatures) {
            if (this.guestOsFeatures == null) {
                this.guestOsFeatures = new ArrayList<GuestOsFeature>(guestOsFeatures.size());
            }
            this.guestOsFeatures.addAll(guestOsFeatures);
            return this;
        }

        public Builder addGuestOsFeatures(GuestOsFeature guestOsFeatures) {
            this.guestOsFeatures.add(guestOsFeatures);
            return this;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Builder setIndex(Integer index) {
            this.index = index;
            return this;
        }

        public AttachedDiskInitializeParams getInitializeParams() {
            return this.initializeParams;
        }

        public Builder setInitializeParams(AttachedDiskInitializeParams initializeParams) {
            this.initializeParams = initializeParams;
            return this;
        }

        public String getInterface() {
            return this.interface2;
        }

        public Builder setInterface(String interface2) {
            this.interface2 = interface2;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public List<String> getLicensesList() {
            return this.licenses;
        }

        public Builder addAllLicenses(List<String> licenses) {
            if (this.licenses == null) {
                this.licenses = new ArrayList<String>(licenses.size());
            }
            this.licenses.addAll(licenses);
            return this;
        }

        public Builder addLicenses(String licenses) {
            this.licenses.add(licenses);
            return this;
        }

        public String getMode() {
            return this.mode;
        }

        public Builder setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public AttachedDisk build() {
            return new AttachedDisk(this.autoDelete, this.boot, this.deviceName, this.diskEncryptionKey, this.guestOsFeatures, this.index, this.initializeParams, this.interface2, this.kind, this.licenses, this.mode, this.source, this.type);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoDelete(this.autoDelete);
            newBuilder.setBoot(this.boot);
            newBuilder.setDeviceName(this.deviceName);
            newBuilder.setDiskEncryptionKey(this.diskEncryptionKey);
            newBuilder.addAllGuestOsFeatures(this.guestOsFeatures);
            newBuilder.setIndex(this.index);
            newBuilder.setInitializeParams(this.initializeParams);
            newBuilder.setInterface(this.interface2);
            newBuilder.setKind(this.kind);
            newBuilder.addAllLicenses(this.licenses);
            newBuilder.setMode(this.mode);
            newBuilder.setSource(this.source);
            newBuilder.setType(this.type);
            return newBuilder;
        }
    }
}

