/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ServiceAccount
implements ApiMessage {
    private final String email;
    private final List<String> scopes;
    private static final ServiceAccount DEFAULT_INSTANCE = new ServiceAccount();

    private ServiceAccount() {
        this.email = null;
        this.scopes = null;
    }

    private ServiceAccount(String email, List<String> scopes) {
        this.email = email;
        this.scopes = scopes;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("email")) {
            return this.email;
        }
        if (fieldName.equals("scopes")) {
            return this.scopes;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getEmail() {
        return this.email;
    }

    public List<String> getScopesList() {
        return this.scopes;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ServiceAccount prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ServiceAccount getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ServiceAccount{email=" + this.email + ", scopes=" + this.scopes + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceAccount) {
            ServiceAccount that = (ServiceAccount)o;
            return Objects.equals(this.email, that.getEmail()) && Objects.equals(this.scopes, that.getScopesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.email, this.scopes);
    }

    public static class Builder {
        private String email;
        private List<String> scopes;

        Builder() {
        }

        public Builder mergeFrom(ServiceAccount other) {
            if (other == ServiceAccount.getDefaultInstance()) {
                return this;
            }
            if (other.getEmail() != null) {
                this.email = other.email;
            }
            if (other.getScopesList() != null) {
                this.scopes = other.scopes;
            }
            return this;
        }

        Builder(ServiceAccount source) {
            this.email = source.email;
            this.scopes = source.scopes;
        }

        public String getEmail() {
            return this.email;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public List<String> getScopesList() {
            return this.scopes;
        }

        public Builder addAllScopes(List<String> scopes) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>(scopes.size());
            }
            this.scopes.addAll(scopes);
            return this;
        }

        public Builder addScopes(String scopes) {
            this.scopes.add(scopes);
            return this;
        }

        public ServiceAccount build() {
            return new ServiceAccount(this.email, this.scopes);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEmail(this.email);
            newBuilder.addAllScopes(this.scopes);
            return newBuilder;
        }
    }
}

