/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRoutersHttpRequest;
import com.google.cloud.compute.v1.DeleteRouterHttpRequest;
import com.google.cloud.compute.v1.GetRouterHttpRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterHttpRequest;
import com.google.cloud.compute.v1.InsertRouterHttpRequest;
import com.google.cloud.compute.v1.ListRoutersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRouterHttpRequest;
import com.google.cloud.compute.v1.PreviewRouterHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionRouterName;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterSettings;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.RoutersScopedList;
import com.google.cloud.compute.v1.UpdateRouterHttpRequest;
import com.google.cloud.compute.v1.stub.RouterStub;
import com.google.cloud.compute.v1.stub.RouterStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RouterClient
implements BackgroundResource {
    private final RouterSettings settings;
    private final RouterStub stub;

    public static final RouterClient create() throws IOException {
        return RouterClient.create(RouterSettings.newBuilder().build());
    }

    public static final RouterClient create(RouterSettings settings) throws IOException {
        return new RouterClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RouterClient create(RouterStub stub) {
        return new RouterClient(stub);
    }

    protected RouterClient(RouterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RouterStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RouterClient(RouterStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RouterSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RouterStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListRoutersPagedResponse aggregatedListRouters(ProjectName project) {
        AggregatedListRoutersHttpRequest request = AggregatedListRoutersHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListRouters(request);
    }

    @BetaApi
    public final AggregatedListRoutersPagedResponse aggregatedListRouters(String project) {
        AggregatedListRoutersHttpRequest request = AggregatedListRoutersHttpRequest.newBuilder().setProject(project).build();
        return this.aggregatedListRouters(request);
    }

    @BetaApi
    public final AggregatedListRoutersPagedResponse aggregatedListRouters(AggregatedListRoutersHttpRequest request) {
        return (AggregatedListRoutersPagedResponse)((Object)this.aggregatedListRoutersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListRoutersHttpRequest, AggregatedListRoutersPagedResponse> aggregatedListRoutersPagedCallable() {
        return this.stub.aggregatedListRoutersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListRoutersHttpRequest, RouterAggregatedList> aggregatedListRoutersCallable() {
        return this.stub.aggregatedListRoutersCallable();
    }

    @BetaApi
    public final Operation deleteRouter(ProjectRegionRouterName router) {
        DeleteRouterHttpRequest request = DeleteRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).build();
        return this.deleteRouter(request);
    }

    @BetaApi
    public final Operation deleteRouter(String router) {
        DeleteRouterHttpRequest request = DeleteRouterHttpRequest.newBuilder().setRouter(router).build();
        return this.deleteRouter(request);
    }

    @BetaApi
    public final Operation deleteRouter(DeleteRouterHttpRequest request) {
        return (Operation)this.deleteRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRouterHttpRequest, Operation> deleteRouterCallable() {
        return this.stub.deleteRouterCallable();
    }

    @BetaApi
    public final Router getRouter(ProjectRegionRouterName router) {
        GetRouterHttpRequest request = GetRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).build();
        return this.getRouter(request);
    }

    @BetaApi
    public final Router getRouter(String router) {
        GetRouterHttpRequest request = GetRouterHttpRequest.newBuilder().setRouter(router).build();
        return this.getRouter(request);
    }

    @BetaApi
    public final Router getRouter(GetRouterHttpRequest request) {
        return (Router)this.getRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRouterHttpRequest, Router> getRouterCallable() {
        return this.stub.getRouterCallable();
    }

    @BetaApi
    public final RouterStatusResponse getRouterStatusRouter(ProjectRegionRouterName router) {
        GetRouterStatusRouterHttpRequest request = GetRouterStatusRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).build();
        return this.getRouterStatusRouter(request);
    }

    @BetaApi
    public final RouterStatusResponse getRouterStatusRouter(String router) {
        GetRouterStatusRouterHttpRequest request = GetRouterStatusRouterHttpRequest.newBuilder().setRouter(router).build();
        return this.getRouterStatusRouter(request);
    }

    @BetaApi
    public final RouterStatusResponse getRouterStatusRouter(GetRouterStatusRouterHttpRequest request) {
        return (RouterStatusResponse)this.getRouterStatusRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRouterStatusRouterHttpRequest, RouterStatusResponse> getRouterStatusRouterCallable() {
        return this.stub.getRouterStatusRouterCallable();
    }

    @BetaApi
    public final Operation insertRouter(ProjectRegionName region, Router routerResource) {
        InsertRouterHttpRequest request = InsertRouterHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setRouterResource(routerResource).build();
        return this.insertRouter(request);
    }

    @BetaApi
    public final Operation insertRouter(String region, Router routerResource) {
        InsertRouterHttpRequest request = InsertRouterHttpRequest.newBuilder().setRegion(region).setRouterResource(routerResource).build();
        return this.insertRouter(request);
    }

    @BetaApi
    public final Operation insertRouter(InsertRouterHttpRequest request) {
        return (Operation)this.insertRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRouterHttpRequest, Operation> insertRouterCallable() {
        return this.stub.insertRouterCallable();
    }

    @BetaApi
    public final ListRoutersPagedResponse listRouters(ProjectRegionName region) {
        ListRoutersHttpRequest request = ListRoutersHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRouters(request);
    }

    @BetaApi
    public final ListRoutersPagedResponse listRouters(String region) {
        ListRoutersHttpRequest request = ListRoutersHttpRequest.newBuilder().setRegion(region).build();
        return this.listRouters(request);
    }

    @BetaApi
    public final ListRoutersPagedResponse listRouters(ListRoutersHttpRequest request) {
        return (ListRoutersPagedResponse)((Object)this.listRoutersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRoutersHttpRequest, ListRoutersPagedResponse> listRoutersPagedCallable() {
        return this.stub.listRoutersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRoutersHttpRequest, RouterList> listRoutersCallable() {
        return this.stub.listRoutersCallable();
    }

    @BetaApi
    public final Operation patchRouter(ProjectRegionRouterName router, Router routerResource) {
        PatchRouterHttpRequest request = PatchRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).setRouterResource(routerResource).build();
        return this.patchRouter(request);
    }

    @BetaApi
    public final Operation patchRouter(String router, Router routerResource) {
        PatchRouterHttpRequest request = PatchRouterHttpRequest.newBuilder().setRouter(router).setRouterResource(routerResource).build();
        return this.patchRouter(request);
    }

    @BetaApi
    public final Operation patchRouter(PatchRouterHttpRequest request) {
        return (Operation)this.patchRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRouterHttpRequest, Operation> patchRouterCallable() {
        return this.stub.patchRouterCallable();
    }

    @BetaApi
    public final RoutersPreviewResponse previewRouter(ProjectRegionRouterName router, Router routerResource) {
        PreviewRouterHttpRequest request = PreviewRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).setRouterResource(routerResource).build();
        return this.previewRouter(request);
    }

    @BetaApi
    public final RoutersPreviewResponse previewRouter(String router, Router routerResource) {
        PreviewRouterHttpRequest request = PreviewRouterHttpRequest.newBuilder().setRouter(router).setRouterResource(routerResource).build();
        return this.previewRouter(request);
    }

    @BetaApi
    public final RoutersPreviewResponse previewRouter(PreviewRouterHttpRequest request) {
        return (RoutersPreviewResponse)this.previewRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PreviewRouterHttpRequest, RoutersPreviewResponse> previewRouterCallable() {
        return this.stub.previewRouterCallable();
    }

    @BetaApi
    public final Operation updateRouter(ProjectRegionRouterName router, Router routerResource) {
        UpdateRouterHttpRequest request = UpdateRouterHttpRequest.newBuilder().setRouter(router == null ? null : router.toString()).setRouterResource(routerResource).build();
        return this.updateRouter(request);
    }

    @BetaApi
    public final Operation updateRouter(String router, Router routerResource) {
        UpdateRouterHttpRequest request = UpdateRouterHttpRequest.newBuilder().setRouter(router).setRouterResource(routerResource).build();
        return this.updateRouter(request);
    }

    @BetaApi
    public final Operation updateRouter(UpdateRouterHttpRequest request) {
        return (Operation)this.updateRouterCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateRouterHttpRequest, Operation> updateRouterCallable() {
        return this.stub.updateRouterCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRoutersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutersHttpRequest, RouterList, Router, ListRoutersPage, ListRoutersFixedSizeCollection> {
        private ListRoutersFixedSizeCollection(List<ListRoutersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutersFixedSizeCollection createEmptyCollection() {
            return new ListRoutersFixedSizeCollection(null, 0);
        }

        protected ListRoutersFixedSizeCollection createCollection(List<ListRoutersPage> pages, int collectionSize) {
            return new ListRoutersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutersPage
    extends AbstractPage<ListRoutersHttpRequest, RouterList, Router, ListRoutersPage> {
        private ListRoutersPage(PageContext<ListRoutersHttpRequest, RouterList, Router> context, RouterList response) {
            super(context, (Object)response);
        }

        private static ListRoutersPage createEmptyPage() {
            return new ListRoutersPage(null, null);
        }

        protected ListRoutersPage createPage(PageContext<ListRoutersHttpRequest, RouterList, Router> context, RouterList response) {
            return new ListRoutersPage(context, response);
        }

        public ApiFuture<ListRoutersPage> createPageAsync(PageContext<ListRoutersHttpRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutersPagedResponse
    extends AbstractPagedListResponse<ListRoutersHttpRequest, RouterList, Router, ListRoutersPage, ListRoutersFixedSizeCollection> {
        public static ApiFuture<ListRoutersPagedResponse> createAsync(PageContext<ListRoutersHttpRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            ApiFuture<ListRoutersPage> futurePage = ListRoutersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRoutersPage, ListRoutersPagedResponse>(){

                public ListRoutersPagedResponse apply(ListRoutersPage input) {
                    return new ListRoutersPagedResponse(input);
                }
            });
        }

        private ListRoutersPagedResponse(ListRoutersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListRoutersFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList, AggregatedListRoutersPage, AggregatedListRoutersFixedSizeCollection> {
        private AggregatedListRoutersFixedSizeCollection(List<AggregatedListRoutersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListRoutersFixedSizeCollection createEmptyCollection() {
            return new AggregatedListRoutersFixedSizeCollection(null, 0);
        }

        protected AggregatedListRoutersFixedSizeCollection createCollection(List<AggregatedListRoutersPage> pages, int collectionSize) {
            return new AggregatedListRoutersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListRoutersPage
    extends AbstractPage<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList, AggregatedListRoutersPage> {
        private AggregatedListRoutersPage(PageContext<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList> context, RouterAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListRoutersPage createEmptyPage() {
            return new AggregatedListRoutersPage(null, null);
        }

        protected AggregatedListRoutersPage createPage(PageContext<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList> context, RouterAggregatedList response) {
            return new AggregatedListRoutersPage(context, response);
        }

        public ApiFuture<AggregatedListRoutersPage> createPageAsync(PageContext<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList> context, ApiFuture<RouterAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListRoutersPagedResponse
    extends AbstractPagedListResponse<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList, AggregatedListRoutersPage, AggregatedListRoutersFixedSizeCollection> {
        public static ApiFuture<AggregatedListRoutersPagedResponse> createAsync(PageContext<AggregatedListRoutersHttpRequest, RouterAggregatedList, RoutersScopedList> context, ApiFuture<RouterAggregatedList> futureResponse) {
            ApiFuture<AggregatedListRoutersPage> futurePage = AggregatedListRoutersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListRoutersPage, AggregatedListRoutersPagedResponse>(){

                public AggregatedListRoutersPagedResponse apply(AggregatedListRoutersPage input) {
                    return new AggregatedListRoutersPagedResponse(input);
                }
            });
        }

        private AggregatedListRoutersPagedResponse(AggregatedListRoutersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListRoutersFixedSizeCollection.createEmptyCollection());
        }
    }
}

