/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NamedPort;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RegionInstanceGroupsSetNamedPortsRequest
implements ApiMessage {
    private final String fingerprint;
    private final List<NamedPort> namedPorts;
    private static final RegionInstanceGroupsSetNamedPortsRequest DEFAULT_INSTANCE = new RegionInstanceGroupsSetNamedPortsRequest();

    private RegionInstanceGroupsSetNamedPortsRequest() {
        this.fingerprint = null;
        this.namedPorts = null;
    }

    private RegionInstanceGroupsSetNamedPortsRequest(String fingerprint, List<NamedPort> namedPorts) {
        this.fingerprint = fingerprint;
        this.namedPorts = namedPorts;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("namedPorts")) {
            return this.namedPorts;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<NamedPort> getNamedPortsList() {
        return this.namedPorts;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RegionInstanceGroupsSetNamedPortsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RegionInstanceGroupsSetNamedPortsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RegionInstanceGroupsSetNamedPortsRequest{fingerprint=" + this.fingerprint + ", namedPorts=" + this.namedPorts + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegionInstanceGroupsSetNamedPortsRequest) {
            RegionInstanceGroupsSetNamedPortsRequest that = (RegionInstanceGroupsSetNamedPortsRequest)o;
            return Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.namedPorts, that.getNamedPortsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.namedPorts);
    }

    public static class Builder {
        private String fingerprint;
        private List<NamedPort> namedPorts;

        Builder() {
        }

        public Builder mergeFrom(RegionInstanceGroupsSetNamedPortsRequest other) {
            if (other == RegionInstanceGroupsSetNamedPortsRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getNamedPortsList() != null) {
                this.namedPorts = other.namedPorts;
            }
            return this;
        }

        Builder(RegionInstanceGroupsSetNamedPortsRequest source) {
            this.fingerprint = source.fingerprint;
            this.namedPorts = source.namedPorts;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public List<NamedPort> getNamedPortsList() {
            return this.namedPorts;
        }

        public Builder addAllNamedPorts(List<NamedPort> namedPorts) {
            if (this.namedPorts == null) {
                this.namedPorts = new ArrayList<NamedPort>(namedPorts.size());
            }
            this.namedPorts.addAll(namedPorts);
            return this;
        }

        public Builder addNamedPorts(NamedPort namedPorts) {
            this.namedPorts.add(namedPorts);
            return this;
        }

        public RegionInstanceGroupsSetNamedPortsRequest build() {
            return new RegionInstanceGroupsSetNamedPortsRequest(this.fingerprint, this.namedPorts);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.addAllNamedPorts(this.namedPorts);
            return newBuilder;
        }
    }
}

