/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.DeleteRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetHealthRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.InsertRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ListRegionBackendServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionBackendServiceName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionBackendServiceSettings;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.UpdateRegionBackendServiceHttpRequest;
import com.google.cloud.compute.v1.stub.RegionBackendServiceStub;
import com.google.cloud.compute.v1.stub.RegionBackendServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionBackendServiceClient
implements BackgroundResource {
    private final RegionBackendServiceSettings settings;
    private final RegionBackendServiceStub stub;

    public static final RegionBackendServiceClient create() throws IOException {
        return RegionBackendServiceClient.create(RegionBackendServiceSettings.newBuilder().build());
    }

    public static final RegionBackendServiceClient create(RegionBackendServiceSettings settings) throws IOException {
        return new RegionBackendServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionBackendServiceClient create(RegionBackendServiceStub stub) {
        return new RegionBackendServiceClient(stub);
    }

    protected RegionBackendServiceClient(RegionBackendServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionBackendServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionBackendServiceClient(RegionBackendServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionBackendServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionBackendServiceStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionBackendService(ProjectRegionBackendServiceName backendService) {
        DeleteRegionBackendServiceHttpRequest request = DeleteRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).build();
        return this.deleteRegionBackendService(request);
    }

    @BetaApi
    public final Operation deleteRegionBackendService(String backendService) {
        DeleteRegionBackendServiceHttpRequest request = DeleteRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService).build();
        return this.deleteRegionBackendService(request);
    }

    @BetaApi
    public final Operation deleteRegionBackendService(DeleteRegionBackendServiceHttpRequest request) {
        return (Operation)this.deleteRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionBackendServiceHttpRequest, Operation> deleteRegionBackendServiceCallable() {
        return this.stub.deleteRegionBackendServiceCallable();
    }

    @BetaApi
    public final BackendService getRegionBackendService(ProjectRegionBackendServiceName backendService) {
        GetRegionBackendServiceHttpRequest request = GetRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).build();
        return this.getRegionBackendService(request);
    }

    @BetaApi
    public final BackendService getRegionBackendService(String backendService) {
        GetRegionBackendServiceHttpRequest request = GetRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService).build();
        return this.getRegionBackendService(request);
    }

    @BetaApi
    public final BackendService getRegionBackendService(GetRegionBackendServiceHttpRequest request) {
        return (BackendService)this.getRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionBackendServiceHttpRequest, BackendService> getRegionBackendServiceCallable() {
        return this.stub.getRegionBackendServiceCallable();
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthRegionBackendService(ProjectRegionBackendServiceName backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthRegionBackendServiceHttpRequest request = GetHealthRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealthRegionBackendService(request);
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthRegionBackendService(String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthRegionBackendServiceHttpRequest request = GetHealthRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealthRegionBackendService(request);
    }

    @BetaApi
    public final BackendServiceGroupHealth getHealthRegionBackendService(GetHealthRegionBackendServiceHttpRequest request) {
        return (BackendServiceGroupHealth)this.getHealthRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHealthRegionBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthRegionBackendServiceCallable() {
        return this.stub.getHealthRegionBackendServiceCallable();
    }

    @BetaApi
    public final Operation insertRegionBackendService(ProjectRegionName region, BackendService backendServiceResource) {
        InsertRegionBackendServiceHttpRequest request = InsertRegionBackendServiceHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setBackendServiceResource(backendServiceResource).build();
        return this.insertRegionBackendService(request);
    }

    @BetaApi
    public final Operation insertRegionBackendService(String region, BackendService backendServiceResource) {
        InsertRegionBackendServiceHttpRequest request = InsertRegionBackendServiceHttpRequest.newBuilder().setRegion(region).setBackendServiceResource(backendServiceResource).build();
        return this.insertRegionBackendService(request);
    }

    @BetaApi
    public final Operation insertRegionBackendService(InsertRegionBackendServiceHttpRequest request) {
        return (Operation)this.insertRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionBackendServiceHttpRequest, Operation> insertRegionBackendServiceCallable() {
        return this.stub.insertRegionBackendServiceCallable();
    }

    @BetaApi
    public final ListRegionBackendServicesPagedResponse listRegionBackendServices(ProjectRegionName region) {
        ListRegionBackendServicesHttpRequest request = ListRegionBackendServicesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionBackendServices(request);
    }

    @BetaApi
    public final ListRegionBackendServicesPagedResponse listRegionBackendServices(String region) {
        ListRegionBackendServicesHttpRequest request = ListRegionBackendServicesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionBackendServices(request);
    }

    @BetaApi
    public final ListRegionBackendServicesPagedResponse listRegionBackendServices(ListRegionBackendServicesHttpRequest request) {
        return (ListRegionBackendServicesPagedResponse)((Object)this.listRegionBackendServicesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionBackendServicesHttpRequest, ListRegionBackendServicesPagedResponse> listRegionBackendServicesPagedCallable() {
        return this.stub.listRegionBackendServicesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionBackendServicesHttpRequest, BackendServiceList> listRegionBackendServicesCallable() {
        return this.stub.listRegionBackendServicesCallable();
    }

    @BetaApi
    public final Operation patchRegionBackendService(ProjectRegionBackendServiceName backendService, BackendService backendServiceResource) {
        PatchRegionBackendServiceHttpRequest request = PatchRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setBackendServiceResource(backendServiceResource).build();
        return this.patchRegionBackendService(request);
    }

    @BetaApi
    public final Operation patchRegionBackendService(String backendService, BackendService backendServiceResource) {
        PatchRegionBackendServiceHttpRequest request = PatchRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.patchRegionBackendService(request);
    }

    @BetaApi
    public final Operation patchRegionBackendService(PatchRegionBackendServiceHttpRequest request) {
        return (Operation)this.patchRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRegionBackendServiceHttpRequest, Operation> patchRegionBackendServiceCallable() {
        return this.stub.patchRegionBackendServiceCallable();
    }

    @BetaApi
    public final Operation updateRegionBackendService(ProjectRegionBackendServiceName backendService, BackendService backendServiceResource) {
        UpdateRegionBackendServiceHttpRequest request = UpdateRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService == null ? null : backendService.toString()).setBackendServiceResource(backendServiceResource).build();
        return this.updateRegionBackendService(request);
    }

    @BetaApi
    public final Operation updateRegionBackendService(String backendService, BackendService backendServiceResource) {
        UpdateRegionBackendServiceHttpRequest request = UpdateRegionBackendServiceHttpRequest.newBuilder().setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.updateRegionBackendService(request);
    }

    @BetaApi
    public final Operation updateRegionBackendService(UpdateRegionBackendServiceHttpRequest request) {
        return (Operation)this.updateRegionBackendServiceCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateRegionBackendServiceHttpRequest, Operation> updateRegionBackendServiceCallable() {
        return this.stub.updateRegionBackendServiceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionBackendServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService, ListRegionBackendServicesPage, ListRegionBackendServicesFixedSizeCollection> {
        private ListRegionBackendServicesFixedSizeCollection(List<ListRegionBackendServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionBackendServicesFixedSizeCollection createEmptyCollection() {
            return new ListRegionBackendServicesFixedSizeCollection(null, 0);
        }

        protected ListRegionBackendServicesFixedSizeCollection createCollection(List<ListRegionBackendServicesPage> pages, int collectionSize) {
            return new ListRegionBackendServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionBackendServicesPage
    extends AbstractPage<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService, ListRegionBackendServicesPage> {
        private ListRegionBackendServicesPage(PageContext<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListRegionBackendServicesPage createEmptyPage() {
            return new ListRegionBackendServicesPage(null, null);
        }

        protected ListRegionBackendServicesPage createPage(PageContext<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListRegionBackendServicesPage(context, response);
        }

        public ApiFuture<ListRegionBackendServicesPage> createPageAsync(PageContext<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionBackendServicesPagedResponse
    extends AbstractPagedListResponse<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService, ListRegionBackendServicesPage, ListRegionBackendServicesFixedSizeCollection> {
        public static ApiFuture<ListRegionBackendServicesPagedResponse> createAsync(PageContext<ListRegionBackendServicesHttpRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListRegionBackendServicesPage> futurePage = ListRegionBackendServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionBackendServicesPage, ListRegionBackendServicesPagedResponse>(){

                public ListRegionBackendServicesPagedResponse apply(ListRegionBackendServicesPage input) {
                    return new ListRegionBackendServicesPagedResponse(input);
                }
            });
        }

        private ListRegionBackendServicesPagedResponse(ListRegionBackendServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionBackendServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

