/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.DeleteRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListRegionAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionAutoscalerName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionAutoscalerList;
import com.google.cloud.compute.v1.RegionAutoscalerSettings;
import com.google.cloud.compute.v1.UpdateRegionAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.RegionAutoscalerStub;
import com.google.cloud.compute.v1.stub.RegionAutoscalerStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionAutoscalerClient
implements BackgroundResource {
    private final RegionAutoscalerSettings settings;
    private final RegionAutoscalerStub stub;

    public static final RegionAutoscalerClient create() throws IOException {
        return RegionAutoscalerClient.create(RegionAutoscalerSettings.newBuilder().build());
    }

    public static final RegionAutoscalerClient create(RegionAutoscalerSettings settings) throws IOException {
        return new RegionAutoscalerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionAutoscalerClient create(RegionAutoscalerStub stub) {
        return new RegionAutoscalerClient(stub);
    }

    protected RegionAutoscalerClient(RegionAutoscalerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionAutoscalerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionAutoscalerClient(RegionAutoscalerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionAutoscalerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionAutoscalerStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionAutoscaler(ProjectRegionAutoscalerName autoscaler) {
        DeleteRegionAutoscalerHttpRequest request = DeleteRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler == null ? null : autoscaler.toString()).build();
        return this.deleteRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation deleteRegionAutoscaler(String autoscaler) {
        DeleteRegionAutoscalerHttpRequest request = DeleteRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).build();
        return this.deleteRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation deleteRegionAutoscaler(DeleteRegionAutoscalerHttpRequest request) {
        return (Operation)this.deleteRegionAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionAutoscalerHttpRequest, Operation> deleteRegionAutoscalerCallable() {
        return this.stub.deleteRegionAutoscalerCallable();
    }

    @BetaApi
    public final Autoscaler getRegionAutoscaler(ProjectRegionAutoscalerName autoscaler) {
        GetRegionAutoscalerHttpRequest request = GetRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler == null ? null : autoscaler.toString()).build();
        return this.getRegionAutoscaler(request);
    }

    @BetaApi
    public final Autoscaler getRegionAutoscaler(String autoscaler) {
        GetRegionAutoscalerHttpRequest request = GetRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).build();
        return this.getRegionAutoscaler(request);
    }

    @BetaApi
    public final Autoscaler getRegionAutoscaler(GetRegionAutoscalerHttpRequest request) {
        return (Autoscaler)this.getRegionAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionAutoscalerHttpRequest, Autoscaler> getRegionAutoscalerCallable() {
        return this.stub.getRegionAutoscalerCallable();
    }

    @BetaApi
    public final Operation insertRegionAutoscaler(ProjectRegionName region, Autoscaler autoscalerResource) {
        InsertRegionAutoscalerHttpRequest request = InsertRegionAutoscalerHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setAutoscalerResource(autoscalerResource).build();
        return this.insertRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation insertRegionAutoscaler(String region, Autoscaler autoscalerResource) {
        InsertRegionAutoscalerHttpRequest request = InsertRegionAutoscalerHttpRequest.newBuilder().setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.insertRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation insertRegionAutoscaler(InsertRegionAutoscalerHttpRequest request) {
        return (Operation)this.insertRegionAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionAutoscalerHttpRequest, Operation> insertRegionAutoscalerCallable() {
        return this.stub.insertRegionAutoscalerCallable();
    }

    @BetaApi
    public final ListRegionAutoscalersPagedResponse listRegionAutoscalers(ProjectRegionName region) {
        ListRegionAutoscalersHttpRequest request = ListRegionAutoscalersHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionAutoscalers(request);
    }

    @BetaApi
    public final ListRegionAutoscalersPagedResponse listRegionAutoscalers(String region) {
        ListRegionAutoscalersHttpRequest request = ListRegionAutoscalersHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionAutoscalers(request);
    }

    @BetaApi
    public final ListRegionAutoscalersPagedResponse listRegionAutoscalers(ListRegionAutoscalersHttpRequest request) {
        return (ListRegionAutoscalersPagedResponse)((Object)this.listRegionAutoscalersPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionAutoscalersHttpRequest, ListRegionAutoscalersPagedResponse> listRegionAutoscalersPagedCallable() {
        return this.stub.listRegionAutoscalersPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionAutoscalersHttpRequest, RegionAutoscalerList> listRegionAutoscalersCallable() {
        return this.stub.listRegionAutoscalersCallable();
    }

    @BetaApi
    public final Operation patchRegionAutoscaler(String autoscaler, ProjectRegionName region, Autoscaler autoscalerResource) {
        PatchRegionAutoscalerHttpRequest request = PatchRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setRegion(region == null ? null : region.toString()).setAutoscalerResource(autoscalerResource).build();
        return this.patchRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation patchRegionAutoscaler(String autoscaler, String region, Autoscaler autoscalerResource) {
        PatchRegionAutoscalerHttpRequest request = PatchRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.patchRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation patchRegionAutoscaler(PatchRegionAutoscalerHttpRequest request) {
        return (Operation)this.patchRegionAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRegionAutoscalerHttpRequest, Operation> patchRegionAutoscalerCallable() {
        return this.stub.patchRegionAutoscalerCallable();
    }

    @BetaApi
    public final Operation updateRegionAutoscaler(String autoscaler, ProjectRegionName region, Autoscaler autoscalerResource) {
        UpdateRegionAutoscalerHttpRequest request = UpdateRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setRegion(region == null ? null : region.toString()).setAutoscalerResource(autoscalerResource).build();
        return this.updateRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation updateRegionAutoscaler(String autoscaler, String region, Autoscaler autoscalerResource) {
        UpdateRegionAutoscalerHttpRequest request = UpdateRegionAutoscalerHttpRequest.newBuilder().setAutoscaler(autoscaler).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.updateRegionAutoscaler(request);
    }

    @BetaApi
    public final Operation updateRegionAutoscaler(UpdateRegionAutoscalerHttpRequest request) {
        return (Operation)this.updateRegionAutoscalerCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateRegionAutoscalerHttpRequest, Operation> updateRegionAutoscalerCallable() {
        return this.stub.updateRegionAutoscalerCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionAutoscalersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler, ListRegionAutoscalersPage, ListRegionAutoscalersFixedSizeCollection> {
        private ListRegionAutoscalersFixedSizeCollection(List<ListRegionAutoscalersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionAutoscalersFixedSizeCollection createEmptyCollection() {
            return new ListRegionAutoscalersFixedSizeCollection(null, 0);
        }

        protected ListRegionAutoscalersFixedSizeCollection createCollection(List<ListRegionAutoscalersPage> pages, int collectionSize) {
            return new ListRegionAutoscalersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionAutoscalersPage
    extends AbstractPage<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler, ListRegionAutoscalersPage> {
        private ListRegionAutoscalersPage(PageContext<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            super(context, (Object)response);
        }

        private static ListRegionAutoscalersPage createEmptyPage() {
            return new ListRegionAutoscalersPage(null, null);
        }

        protected ListRegionAutoscalersPage createPage(PageContext<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            return new ListRegionAutoscalersPage(context, response);
        }

        public ApiFuture<ListRegionAutoscalersPage> createPageAsync(PageContext<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionAutoscalersPagedResponse
    extends AbstractPagedListResponse<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler, ListRegionAutoscalersPage, ListRegionAutoscalersFixedSizeCollection> {
        public static ApiFuture<ListRegionAutoscalersPagedResponse> createAsync(PageContext<ListRegionAutoscalersHttpRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            ApiFuture<ListRegionAutoscalersPage> futurePage = ListRegionAutoscalersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionAutoscalersPage, ListRegionAutoscalersPagedResponse>(){

                public ListRegionAutoscalersPagedResponse apply(ListRegionAutoscalersPage input) {
                    return new ListRegionAutoscalersPagedResponse(input);
                }
            });
        }

        private ListRegionAutoscalersPagedResponse(ListRegionAutoscalersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionAutoscalersFixedSizeCollection.createEmptyCollection());
        }
    }
}

