/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.PathRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PathMatcher
implements ApiMessage {
    private final String defaultService;
    private final String description;
    private final String name;
    private final List<PathRule> pathRules;
    private static final PathMatcher DEFAULT_INSTANCE = new PathMatcher();

    private PathMatcher() {
        this.defaultService = null;
        this.description = null;
        this.name = null;
        this.pathRules = null;
    }

    private PathMatcher(String defaultService, String description, String name, List<PathRule> pathRules) {
        this.defaultService = defaultService;
        this.description = description;
        this.name = name;
        this.pathRules = pathRules;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("defaultService")) {
            return this.defaultService;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("pathRules")) {
            return this.pathRules;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDefaultService() {
        return this.defaultService;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public List<PathRule> getPathRulesList() {
        return this.pathRules;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PathMatcher prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PathMatcher getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PathMatcher{defaultService=" + this.defaultService + ", description=" + this.description + ", name=" + this.name + ", pathRules=" + this.pathRules + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PathMatcher) {
            PathMatcher that = (PathMatcher)o;
            return Objects.equals(this.defaultService, that.getDefaultService()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.pathRules, that.getPathRulesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.defaultService, this.description, this.name, this.pathRules);
    }

    public static class Builder {
        private String defaultService;
        private String description;
        private String name;
        private List<PathRule> pathRules;

        Builder() {
        }

        public Builder mergeFrom(PathMatcher other) {
            if (other == PathMatcher.getDefaultInstance()) {
                return this;
            }
            if (other.getDefaultService() != null) {
                this.defaultService = other.defaultService;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPathRulesList() != null) {
                this.pathRules = other.pathRules;
            }
            return this;
        }

        Builder(PathMatcher source) {
            this.defaultService = source.defaultService;
            this.description = source.description;
            this.name = source.name;
            this.pathRules = source.pathRules;
        }

        public String getDefaultService() {
            return this.defaultService;
        }

        public Builder setDefaultService(String defaultService) {
            this.defaultService = defaultService;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<PathRule> getPathRulesList() {
            return this.pathRules;
        }

        public Builder addAllPathRules(List<PathRule> pathRules) {
            if (this.pathRules == null) {
                this.pathRules = new ArrayList<PathRule>(pathRules.size());
            }
            this.pathRules.addAll(pathRules);
            return this;
        }

        public Builder addPathRules(PathRule pathRules) {
            this.pathRules.add(pathRules);
            return this;
        }

        public PathMatcher build() {
            return new PathMatcher(this.defaultService, this.description, this.name, this.pathRules);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDefaultService(this.defaultService);
            newBuilder.setDescription(this.description);
            newBuilder.setName(this.name);
            newBuilder.addAllPathRules(this.pathRules);
            return newBuilder;
        }
    }
}

