/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AccessConfig;
import com.google.cloud.compute.v1.AliasIpRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkInterface
implements ApiMessage {
    private final List<AccessConfig> accessConfigs;
    private final List<AliasIpRange> aliasIpRanges;
    private final String fingerprint;
    private final String kind;
    private final String name;
    private final String network;
    private final String networkIP;
    private final String subnetwork;
    private static final NetworkInterface DEFAULT_INSTANCE = new NetworkInterface();

    private NetworkInterface() {
        this.accessConfigs = null;
        this.aliasIpRanges = null;
        this.fingerprint = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.networkIP = null;
        this.subnetwork = null;
    }

    private NetworkInterface(List<AccessConfig> accessConfigs, List<AliasIpRange> aliasIpRanges, String fingerprint, String kind, String name, String network, String networkIP, String subnetwork) {
        this.accessConfigs = accessConfigs;
        this.aliasIpRanges = aliasIpRanges;
        this.fingerprint = fingerprint;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.networkIP = networkIP;
        this.subnetwork = subnetwork;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("accessConfigs")) {
            return this.accessConfigs;
        }
        if (fieldName.equals("aliasIpRanges")) {
            return this.aliasIpRanges;
        }
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("network")) {
            return this.network;
        }
        if (fieldName.equals("networkIP")) {
            return this.networkIP;
        }
        if (fieldName.equals("subnetwork")) {
            return this.subnetwork;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AccessConfig> getAccessConfigsList() {
        return this.accessConfigs;
    }

    public List<AliasIpRange> getAliasIpRangesList() {
        return this.aliasIpRanges;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkIP() {
        return this.networkIP;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkInterface prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkInterface getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkInterface{accessConfigs=" + this.accessConfigs + ", aliasIpRanges=" + this.aliasIpRanges + ", fingerprint=" + this.fingerprint + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", networkIP=" + this.networkIP + ", subnetwork=" + this.subnetwork + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkInterface) {
            NetworkInterface that = (NetworkInterface)o;
            return Objects.equals(this.accessConfigs, that.getAccessConfigsList()) && Objects.equals(this.aliasIpRanges, that.getAliasIpRangesList()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.networkIP, that.getNetworkIP()) && Objects.equals(this.subnetwork, that.getSubnetwork());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.accessConfigs, this.aliasIpRanges, this.fingerprint, this.kind, this.name, this.network, this.networkIP, this.subnetwork);
    }

    public static class Builder {
        private List<AccessConfig> accessConfigs;
        private List<AliasIpRange> aliasIpRanges;
        private String fingerprint;
        private String kind;
        private String name;
        private String network;
        private String networkIP;
        private String subnetwork;

        Builder() {
        }

        public Builder mergeFrom(NetworkInterface other) {
            if (other == NetworkInterface.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessConfigsList() != null) {
                this.accessConfigs = other.accessConfigs;
            }
            if (other.getAliasIpRangesList() != null) {
                this.aliasIpRanges = other.aliasIpRanges;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getNetworkIP() != null) {
                this.networkIP = other.networkIP;
            }
            if (other.getSubnetwork() != null) {
                this.subnetwork = other.subnetwork;
            }
            return this;
        }

        Builder(NetworkInterface source) {
            this.accessConfigs = source.accessConfigs;
            this.aliasIpRanges = source.aliasIpRanges;
            this.fingerprint = source.fingerprint;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.networkIP = source.networkIP;
            this.subnetwork = source.subnetwork;
        }

        public List<AccessConfig> getAccessConfigsList() {
            return this.accessConfigs;
        }

        public Builder addAllAccessConfigs(List<AccessConfig> accessConfigs) {
            if (this.accessConfigs == null) {
                this.accessConfigs = new ArrayList<AccessConfig>(accessConfigs.size());
            }
            this.accessConfigs.addAll(accessConfigs);
            return this;
        }

        public Builder addAccessConfigs(AccessConfig accessConfigs) {
            this.accessConfigs.add(accessConfigs);
            return this;
        }

        public List<AliasIpRange> getAliasIpRangesList() {
            return this.aliasIpRanges;
        }

        public Builder addAllAliasIpRanges(List<AliasIpRange> aliasIpRanges) {
            if (this.aliasIpRanges == null) {
                this.aliasIpRanges = new ArrayList<AliasIpRange>(aliasIpRanges.size());
            }
            this.aliasIpRanges.addAll(aliasIpRanges);
            return this;
        }

        public Builder addAliasIpRanges(AliasIpRange aliasIpRanges) {
            this.aliasIpRanges.add(aliasIpRanges);
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getNetworkIP() {
            return this.networkIP;
        }

        public Builder setNetworkIP(String networkIP) {
            this.networkIP = networkIP;
            return this;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public Builder setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
            return this;
        }

        public NetworkInterface build() {
            return new NetworkInterface(this.accessConfigs, this.aliasIpRanges, this.fingerprint, this.kind, this.name, this.network, this.networkIP, this.subnetwork);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAccessConfigs(this.accessConfigs);
            newBuilder.addAllAliasIpRanges(this.aliasIpRanges);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setNetworkIP(this.networkIP);
            newBuilder.setSubnetwork(this.subnetwork);
            return newBuilder;
        }
    }
}

