/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.NetworkPeering;
import com.google.cloud.compute.v1.NetworkRoutingConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Network
implements ApiMessage {
    private final Boolean autoCreateSubnetworks;
    private final String creationTimestamp;
    private final String description;
    private final String gatewayIPv4;
    private final String iPv4Range;
    private final String id;
    private final String kind;
    private final String name;
    private final List<NetworkPeering> peerings;
    private final NetworkRoutingConfig routingConfig;
    private final String selfLink;
    private final List<String> subnetworks;
    private static final Network DEFAULT_INSTANCE = new Network();

    private Network() {
        this.autoCreateSubnetworks = null;
        this.creationTimestamp = null;
        this.description = null;
        this.gatewayIPv4 = null;
        this.iPv4Range = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.peerings = null;
        this.routingConfig = null;
        this.selfLink = null;
        this.subnetworks = null;
    }

    private Network(Boolean autoCreateSubnetworks, String creationTimestamp, String description, String gatewayIPv4, String iPv4Range, String id, String kind, String name, List<NetworkPeering> peerings, NetworkRoutingConfig routingConfig, String selfLink, List<String> subnetworks) {
        this.autoCreateSubnetworks = autoCreateSubnetworks;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.gatewayIPv4 = gatewayIPv4;
        this.iPv4Range = iPv4Range;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.peerings = peerings;
        this.routingConfig = routingConfig;
        this.selfLink = selfLink;
        this.subnetworks = subnetworks;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("autoCreateSubnetworks")) {
            return this.autoCreateSubnetworks;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("gatewayIPv4")) {
            return this.gatewayIPv4;
        }
        if (fieldName.equals("iPv4Range")) {
            return this.iPv4Range;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("peerings")) {
            return this.peerings;
        }
        if (fieldName.equals("routingConfig")) {
            return this.routingConfig;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("subnetworks")) {
            return this.subnetworks;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutoCreateSubnetworks() {
        return this.autoCreateSubnetworks;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGatewayIPv4() {
        return this.gatewayIPv4;
    }

    public String getIPv4Range() {
        return this.iPv4Range;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<NetworkPeering> getPeeringsList() {
        return this.peerings;
    }

    public NetworkRoutingConfig getRoutingConfig() {
        return this.routingConfig;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<String> getSubnetworksList() {
        return this.subnetworks;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Network prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Network getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Network{autoCreateSubnetworks=" + this.autoCreateSubnetworks + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", gatewayIPv4=" + this.gatewayIPv4 + ", iPv4Range=" + this.iPv4Range + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", peerings=" + this.peerings + ", routingConfig=" + this.routingConfig + ", selfLink=" + this.selfLink + ", subnetworks=" + this.subnetworks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Network) {
            Network that = (Network)o;
            return Objects.equals(this.autoCreateSubnetworks, that.getAutoCreateSubnetworks()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.gatewayIPv4, that.getGatewayIPv4()) && Objects.equals(this.iPv4Range, that.getIPv4Range()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.peerings, that.getPeeringsList()) && Objects.equals(this.routingConfig, that.getRoutingConfig()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.subnetworks, that.getSubnetworksList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoCreateSubnetworks, this.creationTimestamp, this.description, this.gatewayIPv4, this.iPv4Range, this.id, this.kind, this.name, this.peerings, this.routingConfig, this.selfLink, this.subnetworks);
    }

    public static class Builder {
        private Boolean autoCreateSubnetworks;
        private String creationTimestamp;
        private String description;
        private String gatewayIPv4;
        private String iPv4Range;
        private String id;
        private String kind;
        private String name;
        private List<NetworkPeering> peerings;
        private NetworkRoutingConfig routingConfig;
        private String selfLink;
        private List<String> subnetworks;

        Builder() {
        }

        public Builder mergeFrom(Network other) {
            if (other == Network.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoCreateSubnetworks() != null) {
                this.autoCreateSubnetworks = other.autoCreateSubnetworks;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getGatewayIPv4() != null) {
                this.gatewayIPv4 = other.gatewayIPv4;
            }
            if (other.getIPv4Range() != null) {
                this.iPv4Range = other.iPv4Range;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPeeringsList() != null) {
                this.peerings = other.peerings;
            }
            if (other.getRoutingConfig() != null) {
                this.routingConfig = other.routingConfig;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSubnetworksList() != null) {
                this.subnetworks = other.subnetworks;
            }
            return this;
        }

        Builder(Network source) {
            this.autoCreateSubnetworks = source.autoCreateSubnetworks;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.gatewayIPv4 = source.gatewayIPv4;
            this.iPv4Range = source.iPv4Range;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.peerings = source.peerings;
            this.routingConfig = source.routingConfig;
            this.selfLink = source.selfLink;
            this.subnetworks = source.subnetworks;
        }

        public Boolean getAutoCreateSubnetworks() {
            return this.autoCreateSubnetworks;
        }

        public Builder setAutoCreateSubnetworks(Boolean autoCreateSubnetworks) {
            this.autoCreateSubnetworks = autoCreateSubnetworks;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getGatewayIPv4() {
            return this.gatewayIPv4;
        }

        public Builder setGatewayIPv4(String gatewayIPv4) {
            this.gatewayIPv4 = gatewayIPv4;
            return this;
        }

        public String getIPv4Range() {
            return this.iPv4Range;
        }

        public Builder setIPv4Range(String iPv4Range) {
            this.iPv4Range = iPv4Range;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<NetworkPeering> getPeeringsList() {
            return this.peerings;
        }

        public Builder addAllPeerings(List<NetworkPeering> peerings) {
            if (this.peerings == null) {
                this.peerings = new ArrayList<NetworkPeering>(peerings.size());
            }
            this.peerings.addAll(peerings);
            return this;
        }

        public Builder addPeerings(NetworkPeering peerings) {
            this.peerings.add(peerings);
            return this;
        }

        public NetworkRoutingConfig getRoutingConfig() {
            return this.routingConfig;
        }

        public Builder setRoutingConfig(NetworkRoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<String> getSubnetworksList() {
            return this.subnetworks;
        }

        public Builder addAllSubnetworks(List<String> subnetworks) {
            if (this.subnetworks == null) {
                this.subnetworks = new ArrayList<String>(subnetworks.size());
            }
            this.subnetworks.addAll(subnetworks);
            return this;
        }

        public Builder addSubnetworks(String subnetworks) {
            this.subnetworks.add(subnetworks);
            return this;
        }

        public Network build() {
            return new Network(this.autoCreateSubnetworks, this.creationTimestamp, this.description, this.gatewayIPv4, this.iPv4Range, this.id, this.kind, this.name, this.peerings, this.routingConfig, this.selfLink, this.subnetworks);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoCreateSubnetworks(this.autoCreateSubnetworks);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setGatewayIPv4(this.gatewayIPv4);
            newBuilder.setIPv4Range(this.iPv4Range);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllPeerings(this.peerings);
            newBuilder.setRoutingConfig(this.routingConfig);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllSubnetworks(this.subnetworks);
            return newBuilder;
        }
    }
}

