/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.License;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class LicensesListResponse
implements ApiMessage {
    private final String id;
    private final List<License> items;
    private final String nextPageToken;
    private final String selfLink;
    private final Warning warning;
    private static final LicensesListResponse DEFAULT_INSTANCE = new LicensesListResponse();

    private LicensesListResponse() {
        this.id = null;
        this.items = null;
        this.nextPageToken = null;
        this.selfLink = null;
        this.warning = null;
    }

    private LicensesListResponse(String id, List<License> items, String nextPageToken, String selfLink, Warning warning) {
        this.id = id;
        this.items = items;
        this.nextPageToken = nextPageToken;
        this.selfLink = selfLink;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("items")) {
            return this.items;
        }
        if (fieldName.equals("nextPageToken")) {
            return this.nextPageToken;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public List<License> getItemsList() {
        return this.items;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LicensesListResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static LicensesListResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "LicensesListResponse{id=" + this.id + ", items=" + this.items + ", nextPageToken=" + this.nextPageToken + ", selfLink=" + this.selfLink + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LicensesListResponse) {
            LicensesListResponse that = (LicensesListResponse)o;
            return Objects.equals(this.id, that.getId()) && Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.items, this.nextPageToken, this.selfLink, this.warning);
    }

    public static class Builder {
        private String id;
        private List<License> items;
        private String nextPageToken;
        private String selfLink;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(LicensesListResponse other) {
            if (other == LicensesListResponse.getDefaultInstance()) {
                return this;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(LicensesListResponse source) {
            this.id = source.id;
            this.items = source.items;
            this.nextPageToken = source.nextPageToken;
            this.selfLink = source.selfLink;
            this.warning = source.warning;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<License> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<License> items) {
            if (this.items == null) {
                this.items = new ArrayList<License>(items.size());
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(License items) {
            this.items.add(items);
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public LicensesListResponse build() {
            return new LicensesListResponse(this.id, this.items, this.nextPageToken, this.selfLink, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setId(this.id);
            newBuilder.addAllItems(this.items);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

