/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ImageList
implements ApiMessage {
    private final String id;
    private final List<Image> items;
    private final String kind;
    private final String nextPageToken;
    private final String selfLink;
    private final Warning warning;
    private static final ImageList DEFAULT_INSTANCE = new ImageList();

    private ImageList() {
        this.id = null;
        this.items = null;
        this.kind = null;
        this.nextPageToken = null;
        this.selfLink = null;
        this.warning = null;
    }

    private ImageList(String id, List<Image> items, String kind, String nextPageToken, String selfLink, Warning warning) {
        this.id = id;
        this.items = items;
        this.kind = kind;
        this.nextPageToken = nextPageToken;
        this.selfLink = selfLink;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("items")) {
            return this.items;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("nextPageToken")) {
            return this.nextPageToken;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public List<Image> getItemsList() {
        return this.items;
    }

    public String getKind() {
        return this.kind;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ImageList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ImageList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ImageList{id=" + this.id + ", items=" + this.items + ", kind=" + this.kind + ", nextPageToken=" + this.nextPageToken + ", selfLink=" + this.selfLink + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageList) {
            ImageList that = (ImageList)o;
            return Objects.equals(this.id, that.getId()) && Objects.equals(this.items, that.getItemsList()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.items, this.kind, this.nextPageToken, this.selfLink, this.warning);
    }

    public static class Builder {
        private String id;
        private List<Image> items;
        private String kind;
        private String nextPageToken;
        private String selfLink;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(ImageList other) {
            if (other == ImageList.getDefaultInstance()) {
                return this;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(ImageList source) {
            this.id = source.id;
            this.items = source.items;
            this.kind = source.kind;
            this.nextPageToken = source.nextPageToken;
            this.selfLink = source.selfLink;
            this.warning = source.warning;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public List<Image> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<Image> items) {
            if (this.items == null) {
                this.items = new ArrayList<Image>(items.size());
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(Image items) {
            this.items.add(items);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public ImageList build() {
            return new ImageList(this.id, this.items, this.kind, this.nextPageToken, this.selfLink, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setId(this.id);
            newBuilder.addAllItems(this.items);
            newBuilder.setKind(this.kind);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

