/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AutoscalersScopedList
implements ApiMessage {
    private final List<Autoscaler> autoscalers;
    private final Warning warning;
    private static final AutoscalersScopedList DEFAULT_INSTANCE = new AutoscalersScopedList();

    private AutoscalersScopedList() {
        this.autoscalers = null;
        this.warning = null;
    }

    private AutoscalersScopedList(List<Autoscaler> autoscalers, Warning warning) {
        this.autoscalers = autoscalers;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("autoscalers")) {
            return this.autoscalers;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Autoscaler> getAutoscalersList() {
        return this.autoscalers;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AutoscalersScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AutoscalersScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AutoscalersScopedList{autoscalers=" + this.autoscalers + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AutoscalersScopedList) {
            AutoscalersScopedList that = (AutoscalersScopedList)o;
            return Objects.equals(this.autoscalers, that.getAutoscalersList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoscalers, this.warning);
    }

    public static class Builder {
        private List<Autoscaler> autoscalers;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(AutoscalersScopedList other) {
            if (other == AutoscalersScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoscalersList() != null) {
                this.autoscalers = other.autoscalers;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(AutoscalersScopedList source) {
            this.autoscalers = source.autoscalers;
            this.warning = source.warning;
        }

        public List<Autoscaler> getAutoscalersList() {
            return this.autoscalers;
        }

        public Builder addAllAutoscalers(List<Autoscaler> autoscalers) {
            if (this.autoscalers == null) {
                this.autoscalers = new ArrayList<Autoscaler>(autoscalers.size());
            }
            this.autoscalers.addAll(autoscalers);
            return this;
        }

        public Builder addAutoscalers(Autoscaler autoscalers) {
            this.autoscalers.add(autoscalers);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public AutoscalersScopedList build() {
            return new AutoscalersScopedList(this.autoscalers, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAutoscalers(this.autoscalers);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

