/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.ResourceId;
import com.google.cloud.compute.deprecated.ZoneId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiskTypeId
extends ResourceId {
    static final Function<String, DiskTypeId> FROM_URL_FUNCTION = new Function<String, DiskTypeId>(){

        public DiskTypeId apply(String pb) {
            return DiskTypeId.fromUrl(pb);
        }
    };
    static final Function<DiskTypeId, String> TO_URL_FUNCTION = new Function<DiskTypeId, String>(){

        public String apply(DiskTypeId diskTypeId) {
            return diskTypeId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)/diskTypes/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)/diskTypes/([^/]+)");
    private static final long serialVersionUID = 7337881474103686219L;
    private final String zone;
    private final String type;

    private DiskTypeId(String project, String zone, String type) {
        super(project);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    public String getType() {
        return this.type;
    }

    public String getZone() {
        return this.zone;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.getProject(), this.zone);
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/zones/" + this.zone + "/diskTypes/" + this.type;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("zone", (Object)this.zone).add("type", (Object)this.type);
    }

    public int hashCode() {
        return Objects.hash(super.baseHashCode(), this.zone, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskTypeId)) {
            return false;
        }
        DiskTypeId other = (DiskTypeId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone) && Objects.equals(this.type, other.type);
    }

    @Override
    DiskTypeId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return DiskTypeId.of(projectId, this.zone, this.type);
    }

    public static DiskTypeId of(ZoneId zoneId, String type) {
        return new DiskTypeId(zoneId.getProject(), zoneId.getZone(), type);
    }

    public static DiskTypeId of(String zone, String type) {
        return DiskTypeId.of(ZoneId.of(null, zone), type);
    }

    public static DiskTypeId of(String project, String zone, String type) {
        return DiskTypeId.of(ZoneId.of(project, zone), type);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static DiskTypeId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid disk type URL");
        }
        return DiskTypeId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

