/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.LicenseId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class License
implements Serializable {
    private static final long serialVersionUID = 6907923910319640363L;
    private final LicenseId licenseId;
    private final Boolean chargesUseFee;

    License(LicenseId licenseId, Boolean chargesUseFee) {
        this.licenseId = (LicenseId)Preconditions.checkNotNull((Object)licenseId);
        this.chargesUseFee = chargesUseFee;
    }

    public LicenseId licenseId() {
        return this.licenseId;
    }

    public Boolean chargesUseFee() {
        return this.chargesUseFee;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("licenseId", (Object)this.licenseId).add("chargesUseFee", (Object)this.chargesUseFee).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.licenseId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(License.class) && Objects.equals(this.toPb(), ((License)obj).toPb());
    }

    com.google.api.services.compute.model.License toPb() {
        com.google.api.services.compute.model.License licensePb = new com.google.api.services.compute.model.License();
        licensePb.setName(this.licenseId.license());
        licensePb.setChargesUseFee(this.chargesUseFee);
        licensePb.setSelfLink(this.licenseId.selfLink());
        return licensePb;
    }

    static License fromPb(com.google.api.services.compute.model.License licensePb) {
        return new License(LicenseId.fromUrl(licensePb.getSelfLink()), licensePb.getChargesUseFee());
    }
}

