/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegionId
extends ResourceId {
    static final Function<String, RegionId> FROM_URL_FUNCTION = new Function<String, RegionId>(){

        public RegionId apply(String pb) {
            return RegionId.fromUrl(pb);
        }
    };
    static final Function<RegionId, String> TO_URL_FUNCTION = new Function<RegionId, String>(){

        public String apply(RegionId regionId) {
            return regionId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/regions/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/regions/([^/]+)");
    private static final long serialVersionUID = 5569092266957249294L;
    private final String region;

    private RegionId(String project, String region) {
        super(project);
        this.region = (String)Preconditions.checkNotNull((Object)region);
    }

    private RegionId(RegionId regionId) {
        super(regionId.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)regionId.getRegion());
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/regions/" + this.region;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("region", (Object)this.region);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.region);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegionId)) {
            return false;
        }
        RegionId other = (RegionId)obj;
        return this.baseEquals(other) && Objects.equals(this.region, other.region);
    }

    @Override
    RegionId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return RegionId.of(projectId, this.region);
    }

    public static RegionId of(String project, String region) {
        return new RegionId(project, region);
    }

    public static RegionId of(String region) {
        return RegionId.of(null, region);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static RegionId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid region URL");
        }
        return RegionId.of(matcher.group(1), matcher.group(2));
    }
}

