/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public abstract class NetworkConfiguration
implements Serializable {
    private static final long serialVersionUID = 6599798536784576564L;
    private final Type type;

    NetworkConfiguration(Type type) {
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    final boolean baseEquals(NetworkConfiguration networkConfiguration) {
        return networkConfiguration != null && this.getClass().equals(networkConfiguration.getClass()) && Objects.equals(this.toPb(), networkConfiguration.toPb());
    }

    abstract Network toPb();

    static <T extends NetworkConfiguration> T fromPb(Network networkPb) {
        if (networkPb.getIPv4Range() != null) {
            return (T)StandardNetworkConfiguration.fromPb(networkPb);
        }
        return (T)SubnetNetworkConfiguration.fromPb(networkPb);
    }

    public static enum Type {
        STANDARD,
        SUBNET;

    }
}

