/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public abstract class ResourceId
implements Serializable {
    static final String REGEX = ".*?projects/([^/]+)/";
    private static final String BASE_URL = "https://www.googleapis.com/compute/v1/projects/";
    private static final long serialVersionUID = -8028734746870421573L;
    private final String project;

    ResourceId(String project) {
        this.project = project;
    }

    public String getSelfLink() {
        String string = String.valueOf(BASE_URL);
        String string2 = String.valueOf(this.project);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public final String getProject() {
        return this.project;
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("project", (Object)this.project);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    int baseHashCode() {
        return Objects.hash(this.project);
    }

    boolean baseEquals(ResourceId resourceId) {
        return Objects.equals(this.project, resourceId.project);
    }

    abstract ResourceId setProjectId(String var1);
}

