/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkId
extends ResourceId {
    private static final String REGEX = ".*?projects/([^/]+)/global/networks/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/networks/([^/]+)");
    private static final long serialVersionUID = 2386765228138819506L;
    private final String network;

    NetworkId(String project, String network) {
        super(project);
        this.network = (String)Preconditions.checkNotNull((Object)network);
    }

    private NetworkId(NetworkId networkId) {
        super(networkId.getProject());
        this.network = (String)Preconditions.checkNotNull((Object)networkId.getNetwork());
    }

    public String getNetwork() {
        return this.network;
    }

    @Override
    public String getSelfLink() {
        String string = String.valueOf(String.valueOf(super.getSelfLink()));
        String string2 = String.valueOf(String.valueOf(this.network));
        return new StringBuilder(17 + string.length() + string2.length()).append(string).append("/global/networks/").append(string2).toString();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("network", (Object)this.network);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.network);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetworkId)) {
            return false;
        }
        NetworkId other = (NetworkId)obj;
        return this.baseEquals(other) && Objects.equals(this.network, other.network);
    }

    @Override
    NetworkId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return NetworkId.of(projectId, this.network);
    }

    public static NetworkId of(String project, String network) {
        return new NetworkId(project, network);
    }

    public static NetworkId of(String network) {
        return NetworkId.of(null, network);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static NetworkId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(url).concat(" is not a valid network URL"));
        }
        return NetworkId.of(matcher.group(1), matcher.group(2));
    }
}

