/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalNetworkEndpointGroupName
implements ResourceName {
    private final String networkEndpointGroup;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/networkEndpointGroups/{networkEndpointGroup}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalNetworkEndpointGroupName(Builder builder) {
        this.networkEndpointGroup = (String)Preconditions.checkNotNull((Object)builder.getNetworkEndpointGroup());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalNetworkEndpointGroupName of(String networkEndpointGroup, String project) {
        return ProjectGlobalNetworkEndpointGroupName.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setProject(project).build();
    }

    public static String format(String networkEndpointGroup, String project) {
        return ProjectGlobalNetworkEndpointGroupName.of(networkEndpointGroup, project).toString();
    }

    public String getNetworkEndpointGroup() {
        return this.networkEndpointGroup;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalNetworkEndpointGroupName projectGlobalNetworkEndpointGroupName = this;
            synchronized (projectGlobalNetworkEndpointGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"networkEndpointGroup", (Object)this.networkEndpointGroup);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalNetworkEndpointGroupName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalNetworkEndpointGroupName>(){

            public ProjectGlobalNetworkEndpointGroupName parse(String formattedString) {
                return ProjectGlobalNetworkEndpointGroupName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalNetworkEndpointGroupName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalNetworkEndpointGroupName.parse: formattedString not in valid format");
        return ProjectGlobalNetworkEndpointGroupName.of((String)matchMap.get("networkEndpointGroup"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"networkEndpointGroup", this.networkEndpointGroup, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalNetworkEndpointGroupName) {
            ProjectGlobalNetworkEndpointGroupName that = (ProjectGlobalNetworkEndpointGroupName)o;
            return Objects.equals(this.networkEndpointGroup, that.getNetworkEndpointGroup()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.networkEndpointGroup, this.project);
    }

    public static class Builder {
        private String networkEndpointGroup;
        private String project;

        public String getNetworkEndpointGroup() {
            return this.networkEndpointGroup;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setNetworkEndpointGroup(String networkEndpointGroup) {
            this.networkEndpointGroup = networkEndpointGroup;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalNetworkEndpointGroupName projectGlobalNetworkEndpointGroupName) {
            this.networkEndpointGroup = projectGlobalNetworkEndpointGroupName.networkEndpointGroup;
            this.project = projectGlobalNetworkEndpointGroupName.project;
        }

        public ProjectGlobalNetworkEndpointGroupName build() {
            return new ProjectGlobalNetworkEndpointGroupName(this);
        }
    }
}

